source [file join [file dirname [info script]] ./../../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_phy/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_sdi/sim/common/modelsim_files.tcl]

namespace eval sdi_mr_rx_sys {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [sdi_mr_rx_sys_rx_phy::get_design_libraries]]
    set libraries [dict merge $libraries [sdi_mr_rx_sys_rx_sdi::get_design_libraries]]
    dict set libraries sdi_mr_rx_sys 1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [sdi_mr_rx_sys_rx_phy::get_memory_files "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_phy/sim/"]]
    set memory_files [concat $memory_files [sdi_mr_rx_sys_rx_sdi::get_memory_files "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_sdi/sim/"]]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [sdi_mr_rx_sys_rx_phy::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_phy/sim/"]]
    set design_files [dict merge $design_files [sdi_mr_rx_sys_rx_sdi::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_sdi/sim/"]]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [list]
    set design_files [concat $design_files [sdi_mr_rx_sys_rx_phy::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_phy/sim/"]]
    set design_files [concat $design_files [sdi_mr_rx_sys_rx_sdi::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_sdi/sim/"]]
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/sdi_mr_rx_sys.v"]\"  -work sdi_mr_rx_sys"
    return $design_files
  }
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [sdi_mr_rx_sys_rx_phy::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [sdi_mr_rx_sys_rx_sdi::get_elab_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [sdi_mr_rx_sys_rx_phy::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [sdi_mr_rx_sys_rx_sdi::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [sdi_mr_rx_sys_rx_phy::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [sdi_mr_rx_sys_rx_sdi::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [sdi_mr_rx_sys_rx_phy::get_dpi_libraries "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_phy/sim/"]]
    set libraries [dict merge $libraries [sdi_mr_rx_sys_rx_sdi::get_dpi_libraries "$QSYS_SIMDIR/../../ip/sdi_mr_rx_sys/sdi_mr_rx_sys_rx_sdi/sim/"]]
    
    return $libraries
  }
  
}
