// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module sdi_rx_phy_access //#()
(
    input  logic        clk,
    input  logic        reset,
    input  logic        en_phy_access,
    input  logic        pdp_avmm_waitrequest,
    input  logic [31:0] pdp_avmm_readdata,
    output logic        pdp_avmm_write,
    output logic        pdp_avmm_read,
    output logic [13:0] pdp_avmm_address,
    output logic [31:0] pdp_avmm_writedata
);

//--------------------------------------
// state assignments
//--------------------------------------
localparam  [1:0]   IDLE                    = 2'd0;
localparam  [1:0]   PHY_RD                  = 2'd1; 
localparam  [1:0]   PHY_CHK_RDDATA          = 2'd2; 
localparam  [1:0]   PHY_WR                  = 2'd3; 

//--------------------------------------
// signals
//--------------------------------------
logic [1:0]     next_state;
logic [1:0]     state;
logic           en_phy_access_applied_posedge;
logic           en_phy_access_applied_negedge;
logic           pdp_read_done;

edge_detector #(
    .EDGE_DETECT    ("POSEDGE")
) u_en_phy_access_posedge_det (
    .clk            (clk),
    .rst            (reset),
    .d              (en_phy_access),
    .q              (en_phy_access_applied_posedge)
);

edge_detector #(
    .EDGE_DETECT    ("NEGEDGE")
) u_en_phy_access_negedge_det (
    .clk            (clk),
    .rst            (reset),
    .d              (en_phy_access),
    .q              (en_phy_access_applied_negedge)
);

//***********************************************************************************
//***************************Control State Machine***********************************
// state register
always @(posedge clk or posedge reset)
begin
    if (reset) begin
        state <= IDLE;
    end else begin
        state <= next_state;
    end
end   

// next state logic
always @ (*) begin
  case(state)
    IDLE: begin
      if (en_phy_access_applied_posedge)
        next_state = PHY_RD;
      else if (en_phy_access_applied_negedge)
        next_state = PHY_WR;
      else
        next_state = IDLE;
    end
    PHY_RD: begin
      if (pdp_avmm_waitrequest && ~pdp_read_done)
        next_state = PHY_RD;
      else
        next_state = PHY_CHK_RDDATA;
    end
    PHY_CHK_RDDATA: begin
      if (en_phy_access) begin
        if (pdp_avmm_readdata[0] == 1'b0)
            next_state = PHY_WR;
        else
            next_state = IDLE;
      end else begin
        if (pdp_avmm_readdata[0] == 1'b1)
            next_state = PHY_WR;
        else
            next_state = IDLE;
        end
    end
    PHY_WR: begin
    if (pdp_avmm_waitrequest)
        next_state = PHY_WR;
    else
        next_state = IDLE;
    end
    default : next_state = IDLE;
  endcase
end

//********************************************************************************
//*****************Generate PHY_Access signals for single PDP Interface***************
//PHY_Access read
always @(posedge clk or posedge reset)
begin
    if (reset)
        pdp_avmm_read  <= 1'b0; 
    else begin
        if(next_state == PHY_RD)
            pdp_avmm_read  <= 1'b1; 
        else
            pdp_avmm_read  <= 1'b0; 
    end
end

//PHY_Access write
always @(posedge clk or posedge reset)
begin
    if (reset)
        pdp_avmm_write  <= 1'b0; 
    else begin
        if(next_state == PHY_WR)
            pdp_avmm_write  <= 1'b1; 
        else 
            pdp_avmm_write  <= 1'b0; 
    end
end

//PHY_Access writedata
always @(posedge clk or posedge reset)
begin
    if (reset) begin
        pdp_avmm_writedata  <= 32'h0;
    end else begin
        if(next_state == PHY_WR)
          if (en_phy_access)
             pdp_avmm_writedata <= {pdp_avmm_readdata[31:1], 1'b1};
          else
             pdp_avmm_writedata <= {pdp_avmm_readdata[31:1], 1'b0};
    end
end

//PHY_Access address
always @ (posedge clk or posedge reset)
begin
    if (reset)
        pdp_avmm_address  <= 14'd0;
    else begin
        if (next_state == PHY_RD)
            pdp_avmm_address <= 14'h206;
    end
end

assign pdp_read_done = (en_phy_access) ? pdp_avmm_read & (!pdp_avmm_waitrequest) : 1'b0;

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "MBeNMpYGPtPl1sE+DQYudSgTsK7EAWNJwUGKRF0u7XRPhowIlls8RJfstyWmsvlOEmdSGdceoRHeaHEQLNzQQIhfBlevOTODcoCezHsI0TKITCVzhv7PoO/WuhggyXiWx6PZ9QL2w6wOssoF+/IIDkKjb9O37NLgtiIz/Y8rj7aO4WI3Z30kcN5p8CvKXADJL6/obbPPFES6e1ypucbAQpHseQQQWhKLHWIfs3d6tL7rrbsu/0vE5yRj5Uly2uK66bdVfuJ97ZjaxwJRFtmFdImQz3tUsQ835y0iIn4sKhsh4oSZMuRv2PCnToN7+FZRjowH6lYw9THHcEpjkV1bhiCXJuYDt+ajGUk4L7T2OjRuKJ5rzX6r7fzA0WYGWfCwGlVuHgSxFeyYNOYxzEh7eKAGXkh6+ibjXwLoXN1v9NKPnmmqZClm7XIypnDfrDgRN697ZL1GMvIiLy0Flk6U2B+RUMgeHrzU+93RHDLF6+Wtbb5FEs750qwSjmrpITp2pB4F8g5nZYTDInQDUjrdG4rlTPxy0D07gNqWHicc+K+oVu6FNGoDR9zPaDSspJYXW6fifejuzPz+GCXbh4rpcFesaAvrsoQBnwcNyN/2IlK/4uqL/q8sH51DZhP3szKdD6zHJH5mEBMcpJ3CqHi3IkU5q+Pozqllul6vexx0v0qAOqPVGT4zjAY4z5MUphF29t2bl+MGkv2Wij+c2PVJjmfsZCuQ+eeT/OlJfsAtKsRhmxvx/ysXGIzr8uDYMzIYhCMBqEeeDR8nqT8JLfMjQC8reK0Mu465z5S39sZjnsrT9Q59gNvBH1c+BjzyqKEMt1BIHvu9VcvBBr1YMY4eTtD1DlfYQ3z0GnyRc8HtKTk/drhk0bVXN/8a5Vxld25ps6/7kW1AHT0CQyQntBF+BsxxYmUaZwD1CZHke7Oejp5BU4w2tl48Sb4DuPnqvspl2uPoSfXjI43lY1Wo1yfcmykJmZoyIDGMtZId0NVgVo7NaF/hUSUPHw1Tpcj+FfhU"
`endif