# (C) 2001-2022 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


#**************************************************************
# Time Information
#**************************************************************
set_time_format -unit ns -decimal_places 3
derive_clock_uncertainty

#**************************************************************
# Tcl Procedure to create Rx clk group
#**************************************************************
proc set_rxclk_grp { sdi_rx_name rxphy_top_name } {

    # List out all the transceiver recovered clocks that are clocking rx_sdi instance registers (register Vsync and Hsync are used as reference)
    # Hsync reg could be recognized as separate clock, due to its function in pfd block in a parallel loopback design.
    # Vsync reg is clocked by rx_clkout2 from Direct PHY IP
    # Rx_ready_sync signal in PHY adapter block is clocked by rx_clkout from Direct PHY IP
    set rx_clkout_H_list [query_collection -all -list_format [get_clocks -nowarn -of_objects "${sdi_rx_name}|u_rx_protocol|sdi_receive_gen[0].u_receive|u_trs|H"]]
    set rx_clkout_list   [query_collection -all -list_format [get_clocks -nowarn -of_objects "${rxphy_top_name}|sdi_phy_adapter_inst|rx_comp_gen.rxdata_3ghd_gen.rx_3ghd_fifo_rdreq"]]
    set rx_sysclk_list   [query_collection -all -list_format [get_clocks -nowarn -of_objects "${rxphy_top_name}|sdi_phy_adapter_inst|rx_comp_gen.gxb_rx_ready_sync_inst|din_s1"]]

    set i 0
    foreach rx_clkout_H $rx_clkout_H_list {
        set rx${i}_clkout_H $rx_clkout_H
        incr i
    }

    set i 0
    foreach rx_clkout $rx_clkout_list {
        set rx${i}_clkout $rx_clkout
        incr i
    }

    set i 0
    foreach rx_sysclk $rx_sysclk_list {
        set rx${i}_sysclk $rx_sysclk
        incr i
    }

    # Multi rate SDI will have 4 profiles while Triple rate SDI will have 2
    # Compare clkout and Hsync regs' clocks, include Hsync clock into the clock group function if they are different.
    if { [get_collection_size [get_clocks -nowarn -of_objects "${rxphy_top_name}|sdi_phy_adapter_inst|rx_comp_gen.rxdata_3ghd_gen.rx_3ghd_fifo_rdreq"]] == 4 } {
        if { [get_collection_size [get_clocks -nowarn -of_objects "${sdi_rx_name}|u_rx_protocol|sdi_receive_gen[0].u_receive|u_trs|H"]] == 0 ||
             [string equal $rx0_clkout $rx0_clkout_H] } {
            set_clock_groups -physically_exclusive  -group [get_clocks "$rx0_clkout $rx0_sysclk"] \
                                                    -group [get_clocks "$rx1_clkout $rx1_sysclk"] \
                                                    -group [get_clocks "$rx2_clkout $rx2_sysclk"] \
                                                    -group [get_clocks "$rx3_clkout $rx3_sysclk"] \
        } else {
            set_clock_groups -physically_exclusive  -group [get_clocks "$rx0_clkout $rx0_clkout_H $rx0_sysclk"] \
                                                    -group [get_clocks "$rx1_clkout $rx1_clkout_H $rx1_sysclk"] \
                                                    -group [get_clocks "$rx2_clkout $rx2_clkout_H $rx2_sysclk"] \
                                                    -group [get_clocks "$rx3_clkout $rx3_clkout_H $rx3_sysclk"] \
        }
    } elseif { [get_collection_size [get_clocks -nowarn -of_objects "${rxphy_top_name}|sdi_phy_adapter_inst|rx_comp_gen.rxdata_3ghd_gen.rx_3ghd_fifo_rdreq"]] == 2 } {
        if { [get_collection_size [get_clocks -nowarn -of_objects "${sdi_rx_name}|u_rx_protocol|sdi_receive_gen[0].u_receive|u_trs|H"]] == 0 ||
             [string equal $rx0_clkout $rx0_clkout_H] } {
            set_clock_groups -physically_exclusive  -group [get_clocks "$rx0_clkout $rx0_sysclk"] \
                                                    -group [get_clocks "$rx1_clkout $rx1_sysclk"]
        } else {
            set_clock_groups -physically_exclusive  -group [get_clocks "$rx0_clkout $rx0_clkout_H $rx0_sysclk"] \
                                                    -group [get_clocks "$rx1_clkout $rx1_clkout_H $rx1_sysclk"]
        }
    }
}



proc set_txclk_grp { sdi_tx_name txphy_top_name } {

    # List out all the transceiver recovered clocks that are clocking rx_sdi instance registers (register Vsync and Hsync are used as reference)
    # Hsync reg could be recognized as separate clock, due to its function in pfd block in a parallel loopback design.
    # Vsync reg is clocked by rx_clkout2 from Direct PHY IP
    # Rx_ready_sync signal in PHY adapter block is clocked by rx_clkout from Direct PHY IP
    set tx_clkout_H_list [query_collection -all -list_format [get_clocks -nowarn -of_objects "${sdi_tx_name}|u_tx_protocol|sdi_receive_gen[0].u_receive|u_trs|H"]]
    set tx_clkout_list   [query_collection -all -list_format [get_clocks -nowarn -of_objects "${txphy_top_name}|sdi_phy_adapter_inst|tx_comp_gen.txdata_3ghd_gen.tx_3ghd_fifo_rdreq"]]
    set tx_sysclk_list   [query_collection -all -list_format [get_clocks -nowarn -of_objects "${txphy_top_name}|sdi_phy_adapter_inst|tx_comp_gen.gxb_tx_ready_sync_inst|din_s1"]]

    set i 0
    foreach tx_clkout_H $tx_clkout_H_list {
        set tx${i}_clkout_H $tx_clkout_H
        incr i
    }

    set i 0
    foreach tx_clkout $tx_clkout_list {
        set tx${i}_clkout $tx_clkout
        incr i
    }

    set i 0
    foreach tx_sysclk $tx_sysclk_list {
        set tx${i}_sysclk $tx_sysclk
        incr i
    }

    # Multi rate SDI will have 4 profiles while Triple rate SDI will have 2
    # Compare clkout and Hsync regs' clocks, include Hsync clock into the clock group function if they are different.
    if { [get_collection_size [get_clocks -nowarn -of_objects "${txphy_top_name}|sdi_phy_adapter_inst|tx_comp_gen.txdata_3ghd_gen.tx_3ghd_fifo_rdreq"]] == 4 } {
        if { [get_collection_size [get_clocks -nowarn -of_objects "${sdi_tx_name}|u_tx_protocol|sdi_receive_gen[0].u_receive|u_trs|H"]] == 0 ||
             [string equal $tx0_clkout $tx0_clkout_H] } {
            set_clock_groups -physically_exclusive  -group [get_clocks "$tx0_clkout $tx0_sysclk"] \
                                                    -group [get_clocks "$tx1_clkout $tx1_sysclk"] \
                                                    -group [get_clocks "$tx2_clkout $tx2_sysclk"] \
                                                    -group [get_clocks "$tx3_clkout $tx3_sysclk"] \
        } else {
            set_clock_groups -physically_exclusive  -group [get_clocks "$tx0_clkout $tx0_clkout_H $tx0_sysclk"] \
                                                    -group [get_clocks "$tx1_clkout $tx1_clkout_H $tx1_sysclk"] \
                                                    -group [get_clocks "$tx2_clkout $tx2_clkout_H $tx2_sysclk"] \
                                                    -group [get_clocks "$tx3_clkout $tx3_clkout_H $tx3_sysclk"] \
        }
    } elseif { [get_collection_size [get_clocks -nowarn -of_objects "${txphy_top_name}|sdi_phy_adapter_inst|tx_comp_gen.txdata_3ghd_gen.tx_3ghd_fifo_rdreq"]] == 2 } {
        if { [get_collection_size [get_clocks -nowarn -of_objects "${sdi_tx_name}|u_tx_protocol|sdi_receive_gen[0].u_receive|u_trs|H"]] == 0 ||
             [string equal $tx0_clkout $tx0_clkout_H] } {
            set_clock_groups -physically_exclusive  -group [get_clocks "$tx0_clkout $tx0_sysclk"] \
                                                    -group [get_clocks "$tx1_clkout $tx1_sysclk"]
        } else {
            set_clock_groups -physically_exclusive  -group [get_clocks "$tx0_clkout $tx0_clkout_H $tx0_sysclk"] \
                                                    -group [get_clocks "$tx1_clkout $tx1_clkout_H $tx1_sysclk"]
        }
    }
}



set_txclk_grp SDI_A7SK_inst|tx_inst|sdi_mr_tx_sys_inst|tx_sdi     SDI_A7SK_inst0|tx_inst|sdi_mr_tx_sys_inst|tx_phy
set_txclk_grp SDI_A7SK_inst|tx_inst0|sdi_mr_tx_sys_inst|tx_sdi    SDI_A7SK_inst0|tx_inst0|sdi_mr_tx_sys_inst|tx_phy
set_txclk_grp SDI_A7SK_inst|tx_inst1|sdi_mr_tx_sys_inst|tx_sdi    SDI_A7SK_inst0|tx_inst1|sdi_mr_tx_sys_inst|tx_phy
set_txclk_grp SDI_A7SK_inst|tx_inst2|sdi_mr_tx_sys_inst|tx_sdi    SDI_A7SK_inst0|tx_inst2|sdi_mr_tx_sys_inst|tx_phy
#**************************************************************
# Create Clock
#**************************************************************
#create_clock -period "10 MHz"       -name {fpga_sgpio_clk} {fpga_sgpio_clk}
#create_clock -period "156.25 MHz"   -name {clk_a_12c_fgt_p_7} {clk_a_12c_fgt_p_7}
#create_clock -period "148.5 MHz"    -name {clk_a_12c_fgt_p_3} {clk_a_12c_fgt_p_3}
#create_clock -period "148.5 MHz"    -name {clk_3a_gpio_p_2} {clk_3a_gpio_p_2}

create_clock -period "100 MHz"       -name {CLK_100_B3A_p} {CLK_100_B3A_p}
create_clock -period "148.5 MHz"   -name {FMCP_REFCLK2_p} {FMCP_REFCLK2_p}
create_clock -period "148.5 MHz"    -name {FMCP_REFCLK3_p} {FMCP_REFCLK3_p}
create_clock -period "148.5 MHz"    -name {CLK_148M5_p} {CLK_148M5_p}




#**************************************************************
# Create clock groups by calling proc on top
#**************************************************************

set_rxclk_grp SDI_A7SK_inst0|rx_inst|sdi_mr_rx_sys_inst|rx_sdi     SDI_A7SK_inst0|rx_inst|sdi_mr_rx_sys_inst|rx_phy
set_rxclk_grp SDI_A7SK_inst0|rx_inst0|sdi_mr_rx_sys_inst|rx_sdi    SDI_A7SK_inst0|rx_inst0|sdi_mr_rx_sys_inst|rx_phy
set_rxclk_grp SDI_A7SK_inst0|rx_inst1|sdi_mr_rx_sys_inst|rx_sdi    SDI_A7SK_inst0|rx_inst1|sdi_mr_rx_sys_inst|rx_phy
set_rxclk_grp SDI_A7SK_inst0|rx_inst2|sdi_mr_rx_sys_inst|rx_sdi    SDI_A7SK_inst0|rx_inst2|sdi_mr_rx_sys_inst|rx_phy




#**************************************************************
# Constraint LEDs
#**************************************************************
set_false_path -from [get_ports fpga_resetn]
set_false_path -from [get_ports fpga_sgpio_sync]
set_false_path -to   [get_ports fpga_sgpo]
