// (C) 2001-2022 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//This reference design file, and your use thereof, is subject to and         
//governed by the terms and conditions of the applicable Intel Reference     
//Design License Agreement.  By using this reference design file, you         
//indicate your acceptance of such terms and conditions between you and       
//Intel Corporation.  In the event that you do not agree with such terms and 
//conditions, you may not use the reference design file. Please promptly      
//destroy any copies you have made.                                           
//                                                                            
//This reference design file being provided on an "as-is" basis and as an     
//accommodation and therefore all warranties, representations or guarantees   
//of any kind (whether express, implied or statutory) including, without      
//limitation, warranties of merchantability, non-infringement, or fitness for 
//a particular purpose, are specifically disclaimed.  By making this          
//reference design file available, Intel expressly does not recommend,       
//suggest or require that this reference design file be used in combination   
//with any other product not provided by Intel.


module sdi_ii_agi_demo (
//Clocks Inputs
    input           FMCP_REFCLK0_p,//default:184.32MHZ -->156.25Mhz 
    input           FMCP_REFCLK1_p,//default:156.25MHZ -->156.25Mhz 
    input           FMCP_REFCLK2_p,//default:100MHZ    -->148.5MHZ
    input           FMCP_REFCLK3_p,//default:148.5 MHz -->148.5MHZ

//SDI daughter card-----------------------------------------------
   //12G port      -----------------------------------------------
   input                      SDI_12G_RX_p0,      // Transceiver Data FPGA 12G-port  RX0
   input                      SDI_12G_RX_n0,
   output                     SDI_12G_TX_p0,      // Transceiver Data FPGA 12G-port  TX0
   output                     SDI_12G_TX_n0,
   input                      SDI_12G_RX_p1,      // Transceiver Data FPGA 12G-port  RX1
   input                      SDI_12G_RX_n1,
   output                     SDI_12G_TX_p1,      // Transceiver Data FPGA 12G-port  TX1
   output                     SDI_12G_TX_n1,

	input 		     [1:0]		SDI_12G_RC_ALARM_n,
	input 		     [1:0]		SDI_12G_RC_LOS,
	input 		     [1:0]		SDI_12G_RX_LOS,
	input 		     [1:0]		SDI_12G_RX_ALARM_n,
	input 		     [1:0]		SDI_12G_RX_SD_XHD,
	output		          		SDI_12G_SPI_SCLK,
	output		          		SDI_12G_SPI_CS_n,
	output		             	SDI_12G_SPI_SDI,
	input		          		   SDI_12G_SPI_SDO,
	
   //3G port      -----------------------------------------------
	input 		     		      SDI_3G_RX_p0,       // Transceiver Data FPGA 3G-port  RX0
	input 		     		      SDI_3G_RX_n0,
	output		     		      SDI_3G_TX_p0,       // Transceiver Data FPGA 3G-port  TX0	
	output		     		      SDI_3G_TX_n0,	
	input 		     		      SDI_3G_RX_p1,       // Transceiver Data FPGA 3G-port  RX1      
	input 		     		      SDI_3G_RX_n1,
	output		     		      SDI_3G_TX_p1,       // Transceiver Data FPGA 3G-port  TX1
	output		     		      SDI_3G_TX_n1,	
	
	output		          		SDI_3G_SPI_SCK,
	input 		          		SDI_3G_SPI_MISO,	
	output		     [1:0]		SDI_3G_SPI_SS_n,
	output		     [1:0]		SDI_3G_TX_EN,
	output		     [1:0]		SDI_3G_TX_RATE_SEL,
	output		          		SDI_3G_SPI_MOSI,
	input 		     [1:0]		SDI_3G_CD_n,	
	
	//------------------------------------------------------------
   input                      CPU_RESET_n,
   input    [ 1: 0]           BUTTON, //BUTTON is Low-Active

   ///////// Swtiches /////////
   input    [ 1: 0]   SW,

   ///////// LED /////////
   output   [ 1: 0]   LED, //LED is Low-Active
	
   ///////// CLOCK /////////
   input              CLK_100_B3A_p,
   input              CLK_100_p,
   input              CLK_148M5_p,	
   input              CLK_50_B2E_p,
	input              CLK_50_B2D_p,
   input              CLK_50_B3A_p,
   input              CLK_50_B3C_p,	
	
      ///////// SI5340A0 /////////
   inout              SI5340A0_I2C_SCL,
   inout              SI5340A0_I2C_SDA,
   output             SI5340A0_OE_n,
   output             SI5340A0_RST_n,

      ///////// SI5340A1 /////////
   inout              SI5340A1_I2C_SCL,
   inout              SI5340A1_I2C_SDA,
   output             SI5340A1_OE_n,
   output             SI5340A1_RST_n		
		
);
wire  RESET_N;
//---reset
assign RESET_N   = CPU_RESET_n; 

//---reset dealy
wire READY_CLOCK ; 
RESET_DELAY RESET_DELAY_1  (
  .RESET_N      (  RESET_N            ),
  .CLK          (  CLK_100_B3A_p      ),
  .READY_CLOCK  (  READY_CLOCK        )
);

//----- Configure SI5340A 
`define SI5340A_FREQ_644M53125     4'h0  
`define SI5340A_FREQ_625M          4'h1  
`define SI5340A_FREQ_322M265625    4'h2  
`define SI5340A_FREQ_312M5         4'h3  
`define SI5340A_FREQ_250M          4'h4  
`define SI5340A_FREQ_184M32        4'h5  
`define SI5340A_FREQ_156M25        4'h6  
`define SI5340A_FREQ_148M5         4'h7  
`define SI5340A_FREQ_125M          4'h8  
`define SI5340A_FREQ_100M          4'h9  

//-- start config
assign si5340a_controller_start = 0;//READY_CLOCK ;
wire [1:0] si5340a_config_done ;
//----- reconfig Si5340A (U77)-----
//QSFP28_REFCLK_p[0]:default 156.25MHZ  Si5340_0_OUT0 
//QSFP28_REFCLK_p[1]:default 184.32MHZ  Si5340_0_OUT1
DE10AGILEX_SI5340A_CONFIG si5340a_controller_a0(
    .iCLK                (CLK_50_B2E_p),
    .iRST_n              (1'b1),
    .iStart              (si5340a_controller_start),
    .iFREQ_OUT_0         ( `SI5340A_FREQ_156M25 ),//QSFP28_REFCLK_p0(FGT PLL) , specify desired out frequency for Si5340 output port 0 by constant SI5340A_FREQ_1_XXX 
    .iFREQ_OUT_1         ( `SI5340A_FREQ_184M32 ),//QSFP28_REFCLK_p1(FGT PLL), specify desired out frequency for Si5340 output port 1 by constant SI5340A_FREQ_1_XXX 
	 .iFREQ_OUT_3         ( `SI5340A_FREQ_148M5  ),//CLKGEN_100_p    (IO PLL ), specify desired out frequency for Si5340 output port 3 by constant SI5340A_FREQ_1_XXX 
    .I2C_CLK             (SI5340A0_I2C_SCL),
    .I2C_DATA            (SI5340A0_I2C_SDA),
    .oPLL_REG_CONFIG_DONE  ( si5340a_config_done[0])
);
assign SI5340A0_OE_n  = 1'b0;
assign SI5340A0_RST_n = 1'b1;


//----- reconfig Si5340 (U68)-----
//FMCP_REFCLK_p[1]:default 156.25MHZ  Si5340_1_OUT0
//FMCP_REFCLK_p[0]:default 184.32MHZ  Si5340_1_OUT1 
DE10AGILEX_SI5340A_CONFIG si5340a_controller_a1(
    .iCLK                (CLK_50_B2E_p),
    .iRST_n              (1'b1),
    .iStart              (si5340a_controller_start),
    .iFREQ_OUT_0         ( `SI5340A_FREQ_156M25 ),//FMCP_REFCLK1_p (FGT PLL) , specify desired out frequency for Si5340 output port 0 by constant SI5340A_FREQ_1_XXX 
    .iFREQ_OUT_1         ( `SI5340A_FREQ_156M25 ),//FMCP_REFCLK0_p (FGT PLL), specify desired out frequency for Si5340 output port 1 by constant SI5340A_FREQ_1_XXX 
	 .iFREQ_OUT_3         ( `SI5340A_FREQ_148M5  ),//CLKGEN_148M5_p (IO PLL ), specify desired out frequency for Si5340 output port 3 by constant SI5340A_FREQ_1_XXX 
    .I2C_CLK             (SI5340A1_I2C_SCL),
    .I2C_DATA            (SI5340A1_I2C_SDA),
    .oPLL_REG_CONFIG_DONE  ( si5340a_config_done[1])
);
assign SI5340A1_OE_n  = 1'b0;
assign SI5340A1_RST_n = 1'b1;


//---U27& U32 (LMH0387) config
SPI_3G_2CH  SPI_3G_2CH_inst(
    .RESET_N               ( READY_CLOCK        ),
    .CLK                   ( CLK_100_B3A_p         ),
    .SPI_SS_n              ( SDI_3G_SPI_SS_n    ), 
    .SPI_SCLK              ( SDI_3G_SPI_SCK     ),  
    .SPI_MOSI              ( SDI_3G_SPI_MOSI    ),
    .SPI_MISO              ( SDI_3G_SPI_MISO    ),	  
    .CD_n                  ( SDI_3G_CD_n        )  ,
	 .CH_POWERDN            ( SDI_3G_TX_EN ) 	 
)  ;


//SW[0]    : 3G DULEX_change  /1: CH0 TX - CH1 RX  , 0:  CH0 RX - CH1 TX 
assign SDI_3G_TX_EN      =  {   ~SW[0]  , SW[0] } ;

//BUTTON 1 : TX SD/3G out slection , 0:SD  1:3G
assign SDI_3G_TX_RATE_SEL=  { ~BUTTON[1] ,  ~BUTTON[1] }  ;  //1:SD   , 0:HD

//----2CH SPI Daisy Chain for 12G cahnnel (to config M23145 & MACD-23528A & M23554 )
SPI_12G_2CH  SPI_12G_2CH_inst(
    .RESET_N               ( READY_CLOCK        ),
    .CLK                   ( CLK_100_B3A_p      ),
	 .MUTE                  ( BUTTON[0]          ) , //12G TX port Mute
    .SPI_CS_n              ( SDI_12G_SPI_CS_n   ), 
    .SPI_SCLK              ( SDI_12G_SPI_SCLK   ),  
    .SPI_SDO               ( SDI_12G_SPI_SDO    ),
    .SPI_SDI               ( SDI_12G_SPI_SDI    ),	  
    .FMC_SDI_12G_RC_LOS    ( SDI_12G_RC_LOS     ),
	 .FMC_SDI_12G_RX_LOS    ( SDI_12G_RX_LOS     ),
    .FMC_SDI_12G_RC_ALARM_n( SDI_12G_RC_ALARM_n ),
    .FMC_SDI_12G_RX_SD_xHD ( SDI_12G_RX_SD_XHD  ),
    .FMC_SDI_12G_RX_ALARM_n( SDI_12G_RX_ALARM_n )    
)  ;



//----------REFCLK Measure , view SignalTapeII --------
//--1hz generater 
wire M50_1HZ ;
CLOCKMEM  ck2( .RST_n(BUTTON[0]), .CLK(CLK_50_B3C_p) ,.CLK_FREQ ( 50000000 )  ,.CK_1HZ( M50_1HZ ) ) ;
FRE_MEASURE fCLK_50_B3C_p         ( .RESET_n(BUTTON[0]),.MES_CLK (CLK_50_B3C_p)   , .HZ1(M50_1HZ) , .FREQ( ) ); 
FRE_MEASURE fout_refclk_fgt_00    ( .RESET_n(BUTTON[0]),.MES_CLK (out_coreclk_0[0])   , .HZ1(M50_1HZ) , .FREQ( ) ); 
FRE_MEASURE fout_refclk_fgt_01    ( .RESET_n(BUTTON[0]),.MES_CLK (out_coreclk_0[1])   , .HZ1(M50_1HZ) , .FREQ( ) ); 
FRE_MEASURE foutclk_148m5_1       ( .RESET_n(BUTTON[0]),.MES_CLK (out_coreclk_1[0]    )   , .HZ1(M50_1HZ) , .FREQ( ) ); 
FRE_MEASURE foutclk_148m5_2       ( .RESET_n(BUTTON[0]),.MES_CLK (out_coreclk_1[1]    )   , .HZ1(M50_1HZ) , .FREQ( ) ); 

FRE_MEASURE fCLK_148M5_p       ( .RESET_n(BUTTON[0]),.MES_CLK (CLK_148M5_p   )   , .HZ1(M50_1HZ) , .FREQ( ) ); 
FRE_MEASURE fCLK_100_p         ( .RESET_n(BUTTON[0]),.MES_CLK (CLK_100_p     )   , .HZ1(M50_1HZ) , .FREQ( ) ); 

//-------------------------------------------------------------------------------
// F-tile Reference and System Clocks
//-------------------------------------------------------------------------------
logic outclk_148m5_1;
logic out_systempll_clk_1;
 
wire [1:0]out_systempll_synthlock;

wire [1:0] out_coreclk_0;            
wire [1:0] out_coreclk_1;
wire [1:0] out_refclk_fgt_0 ; 
logic      out_systempll_clk_2;
logic      outclk_148m5_2     ;

wire       si5340_ok_delay;
wire       avmm_reset ;
wire [2:0] refclock_ready1 ; 
wire [2:0] refclock_ready2 ;

assign refclock_ready1 ={1'b0,si5340_ok_delay,si5340_ok_delay }; 
assign refclock_ready2 ={1'b0,si5340_ok_delay,si5340_ok_delay }; 

RESET_DELAY  RESET_DELAY_2 (
  .RESET_N       (  &si5340a_config_done ),
  .CLK           (  CLK_100_B3A_p      ),
  .READY_CLOCK   (  si5340_ok_delay ),//deley
  .READY_CLOCK_2 (  avmm_reset      ) //delay delay
);
//--to SDI_A7SK_inst0--
xcvr_ref_sysclk xcvr_ref_sysclk_inst2 (
//------------------------ Refclk #i is active at and after device configuration is set to OFF ----
	/*input  wire      */.avmm_clk                ( CLK_148M5_p ),//CLK_100_B3A_p),
   /*input  wire      */.avmm_reset              ( avmm_reset | ~BUTTON[0]),	 
	/*input  wire [2:0]*/.refclock_ready          ( refclock_ready2),        
	/*input  wire      */.en_refclk_fgt_0         ( si5340_ok_delay),        
	/*input  wire      */.en_refclk_fgt_1         ( si5340_ok_delay),        
	/*input  wire      */.disable_refclk_monitor_0(~si5340_ok_delay),  
	/*input  wire      */.disable_refclk_monitor_1(~si5340_ok_delay),      
//------------------------ Refclk #i is active at and after device configuration is set to ON ----	
	 .in_refclk_fgt_0                 (FMCP_REFCLK0_p      ), // 184.32MHZ -->156.25Mhz
    .in_refclk_fgt_1                 (FMCP_REFCLK2_p      ), // 100MHZ    -->148.5MHZ
    .out_systempll_clk_0             (out_systempll_clk_2 ), // 900MHZ    -->phy systempll
	 .out_refclk_fgt_0                (out_refclk_fgt_0[1] ), // no use
    .out_refclk_fgt_1                (outclk_148m5_2      ), // 148.5MHZ to rx_cdr_refclk 
	 .out_coreclk_0                   (out_coreclk_0[1]    ), // 156.25Mhz to user logic         
	 .out_coreclk_1                   (out_coreclk_1[1]    ),  // 148.5Mhz to user logic         
    .out_systempll_synthlock_0       (out_systempll_synthlock[1])	 
);

//--no use
xcvr_ref_sysclk xcvr_ref_sysclk_inst (
//------------------------ Refclk #i is active at and after device configuration is set to Off----
	   /*input  wire      */.avmm_clk                ( CLK_148M5_p ),//CLK_100_B3A_p),
	   /*input  wire      */.avmm_reset              ( avmm_reset | ~BUTTON[0]),	 
		/*input  wire [2:0]*/.refclock_ready          ( refclock_ready1),          
		/*input  wire      */.en_refclk_fgt_0         ( si5340_ok_delay),          
		/*input  wire      */.en_refclk_fgt_1         ( si5340_ok_delay),          
		/*input  wire      */.disable_refclk_monitor_0(~si5340_ok_delay),  
		/*input  wire      */.disable_refclk_monitor_1(~si5340_ok_delay),
		
//------------------------ Refclk #i is active at and after device configuration is set to ON ----	
    .in_refclk_fgt_0                (FMCP_REFCLK1_p      ),     // 156.25MHZ
    .in_refclk_fgt_1                (FMCP_REFCLK3_p      ),     // 148.5MMHZ
    .out_systempll_clk_0            (out_systempll_clk_1 ),     // 900MHZ
	 .out_refclk_fgt_0               (out_refclk_fgt_0[0] ),     // no use
    .out_refclk_fgt_1               (outclk_148m5_1      ),     // no use
	 .out_coreclk_0                  (out_coreclk_0[0]    ),     // 156.25Mhz to user logic            
	 .out_coreclk_1                  (out_coreclk_1[0]    ),     // 148.5Mhz to user logic    
    .out_systempll_synthlock_0      (out_systempll_synthlock[0])	 
);


//----heart
wire [5:0]HZ ; 
CLOCKMEM  HZ_CLK_148M5_p    ( .RST_n(BUTTON[0]  ) ,.CLK( CLK_148M5_p),.CLK_FREQ   ( 148_500_000)  ,.CK_1HZ( HZ[0] ) ) ;
CLOCKMEM  HZ_CLK_100_p      ( .RST_n(BUTTON[0]  ) ,.CLK( CLK_100_p  ),.CLK_FREQ   ( 148_500_000)  ,.CK_1HZ( HZ[1] ) ) ;
CLOCKMEM  HZ_CLK_50_B2E_p   ( .RST_n(BUTTON[0]  ) ,.CLK( CLK_50_B2E_p  ),.CLK_FREQ   ( 50_000_000)  ,.CK_1HZ( HZ[3] ) ) ;

CLOCKMEM  HZ_out_refclk_fgt_01  ( .RST_n(BUTTON[0]  ) ,.CLK( out_coreclk_0[1]),.CLK_FREQ   ( 156_250_000)  ,.CK_1HZ( HZ[4] ) ) ;
CLOCKMEM  HZ_outclk_148m5_2     ( .RST_n(BUTTON[0]  ) ,.CLK( out_coreclk_1[1]),.CLK_FREQ   ( 148_500_000)  ,.CK_1HZ( HZ[5] ) ) ;
    


wire [3:0]RX_LED;
//=== SW[0]
//--SW[1]=1 : LED[1]--> heart of FMCP_REFCLK2_p(148.5Mhz) ,LED[0]-->heart of FMCP_REFCLK0_p (156.25Mhz)
//--SW[1]=0 : LED[1]--> systempll LOCK                    ,LED[0]--> si5340a IP config_done

//=== !SW[0]
//--SW[1]=1 : LED[1] 12G RX1 locked( "1" lock) ,LED[0] 12G RX0 locked( "1" lock)
//--SW[1]=0 : LED[1]  3G RX1 locked( "1" lock) ,LED[0]  3G RX0 locked( "1" lock)

assign LED = SW[0]? ( SW[1]? HZ[5:4] :{~out_systempll_synthlock[1], ~&si5340a_config_done} ) : ( SW[1]?RX_LED[3:2]:RX_LED[1:0] );
             
//---4 PORT SDI RXTX-- 
SDI_A7SK SDI_A7SK_inst0(
            .fpga_resetn      (CPU_RESET_n  &  ~avmm_reset      ),
  /*input */.tx_system_pll_clk(out_systempll_clk_2),
  /*input */.tx_pll_refclk    (outclk_148m5_2     ),
  /*input */.rx_system_pll_clk(out_systempll_clk_2),
  /*input */.rx_cdr_refclk    (outclk_148m5_2     ),
  /*input */.gpio_clk_148M5   (CLK_148M5_p        ),
  /*output*/.sdi_3g_tx_p0    (SDI_3G_TX_p0      ),
  /*output*/.sdi_3g_tx_n0    (SDI_3G_TX_n0      ),
  /*input */.sdi_3g_rx_p0    (SDI_3G_RX_p0      ),
  /*input */.sdi_3g_rx_n0    (SDI_3G_RX_n0      ),
  /*output*/.sdi_3g_tx_p1    (SDI_3G_TX_p1      ),
  /*output*/.sdi_3g_tx_n1    (SDI_3G_TX_n1      ),
  /*input */.sdi_3g_rx_p1    (SDI_3G_RX_p1      ),
  /*input */.sdi_3g_rx_n1    (SDI_3G_RX_n1      ),

  /*output*/.sdi_12g_tx_p0    (SDI_12G_TX_p0    ),
  /*output*/.sdi_12g_tx_n0    (SDI_12G_TX_n0    ),
  /*input */.sdi_12g_rx_p0    (SDI_12G_RX_p0    ),
  /*input */.sdi_12g_rx_n0    (SDI_12G_RX_n0    ),
  /*output*/.sdi_12g_tx_p1    (SDI_12G_TX_p1    ),
  /*output*/.sdi_12g_tx_n1    (SDI_12G_TX_n1    ),
  /*input */.sdi_12g_rx_p1    (SDI_12G_RX_p1    ),
  /*input */.sdi_12g_rx_n1    (SDI_12G_RX_n1    ),
            .LED              (RX_LED[3:0]      )
);


endmodule

