// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
// Copyright 2012 Intel Corporation. All rights reserved.  
// Intel products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Intel Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Intel Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are specifically disclaimed.  By making this reference
// design file available, Intel expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Intel.
/////////////////////////////////////////////////////////////////////////////

// baeckler - 01-25-2012
// force the decomposition of 5 bit FIFO pointer compare with enable

module directphy_f_eq_5_ena #(
 	parameter TARGET_CHIP = 1   // 0 generic, 1 S4, 2 S5
)(
	input [4:0] da,
	input [4:0] db,
	input ena,
	output eq
);

wire w0_o;
directphy_f_wys_lut w0 (
	.a(da[0]),
	.b(da[1]),
	.c(da[2]),
	.d(db[0]),
	.e(db[1]),
	.f(db[2]),
	.out (w0_o)
);
defparam w0 .TARGET_CHIP = TARGET_CHIP;
defparam w0 .MASK = 64'h8040201008040201; // {a,b,c} == {d,e,f}
	
directphy_f_wys_lut w1 (
	.a(ena),
	.b(da[3]),
	.c(da[4]),
	.d(db[3]),
	.e(db[4]),
	.f(w0_o),
	.out (eq)
);
defparam w1 .TARGET_CHIP = TARGET_CHIP;
defparam w1 .MASK = 64'h8020080200000000; // ({b,c} == {d,e}) && a && f
	

endmodule
// BENCHMARK INFO :  10AX115R2F40I2SGES
// BENCHMARK INFO :  Quartus II 64-Bit Version 13.1a10.0 Build 343 10/23/2013 SJ Full Version
// BENCHMARK INFO :  Total registers : 0
// BENCHMARK INFO :  Total pins : 12
// BENCHMARK INFO :  Total virtual pins : 0
// BENCHMARK INFO :  Total block memory bits : 0
// BENCHMARK INFO :  Comb ALUTs :  3              
// BENCHMARK INFO :  ALMs : 3 / 427,200 ( < 1 % )
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRw3t6f70sSUSspz9WdODJhuVMvGnBka6A7IegKM2yKpQEdbhxHGYC1F2fOshBOzF68Kigi7lKulibn1Is9TfRn49It+slSii7r4QcaL+0kjRT9smwyvdH9IdJ0ZO2JMwCdMEY6IpjNbobNOCqa37j7VAUyoKdQ1mN5/XXb2mPiCAazI9Zq/gGl3swYH0HF0HVSfLuxfroOp76tUP50TjIyrgRCpgpB/688KEXTjvnDPdwErUtfES4yRmlTo/CdEm9YOxOcEdjH+lnp9I13Qv+ds8Q+/h23aruStj8PQA4OFAYXo8J8UGaYxh3m2GWeuyNAPqm6UDFCNQ1JkFb2uJ6QxKg7DEO0BKlkxzWMHKRIzkgBXjjd+dmT1StbNK+wbadeAsD8cQy4YygXWQ2KIr41QGubaFDzUw4hNdPwaht2/6+ShDlY9upfBaTPo0RebEZENLDdz4apkg8B9vgGu2o4AdfM9o37fwkxubYShZa/ZGkKfy1Hx2aYpVKYYVNepECBto/dH7T6kOP+ydZ4c0ty2jGmKEd5jFZwTnjEhTs9BQbM7LrbX32U9Jx/y3IvjVpp8TBVdNa4PgHaynfnjgH2pkskHWU3S3NVpHPO1fEBVNzbVKqHndid3muAgi3o5MchflOWoCCpipJF1LNR5OBDVndfrdLE5bNKpo6+HlHaYe2nlNOG3DHDtNZ25kndl5lIvbQiPV20qHF3zieo5+0qDmuM16Mjpq1nkl4xosKUFof9rP2q5F8V0KuXOFXBQMKSni3pcx5hDJWGIqPdqMtpw"
`endif