// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ps/1ps

module directphy_f_gray_cntr_3 #(
	parameter INIT_VAL = 4'h0
)(
	input clk,
	input ena,
	input aclr,
	output reg [2:0] cntr
);

initial cntr = INIT_VAL;

always @(posedge clk or posedge aclr) begin
	if (aclr) cntr <= INIT_VAL;
	else begin
		if (ena) begin
			case (cntr) 
				3'h0 : cntr <= 3'h1;
				3'h1 : cntr <= 3'h3;
				3'h2 : cntr <= 3'h6;
				3'h3 : cntr <= 3'h2;
				3'h4 : cntr <= 3'h0;
				3'h5 : cntr <= 3'h4;
				3'h6 : cntr <= 3'h7;
				3'h7 : cntr <= 3'h5;
			endcase
		end
	end
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "EuDK9zG4ugiX6bYeG9fkF8FUFwPRbgVIE6SygcJWoXuuaS4/+tL/ICR9sNx6uB3Kj3mUnIREp4mwUwZMubvTqsZcZoX0L/B5JV5k+lHdxdt62kmOijVOFdzJpnqmAVvPH7A96JSBQK9foFtswKYNvQUQ2+CWOyvTAMYEcYud/KOqbMyKXMgXytIkjKbvFb0Btu42lszADoIzluQfKUm8UY0h+KnrrRgSFDhz2POB1v0/t9A6FjAS2LI6VdeHz8IacCbOkynAPVnSC15lz0BR3oCX38CzshZbwJTMTMG3fUB6gpmn+bEzhPm1DMF9VT9u5Kn1hX8b3CdwW337V2SAu0ERiaittM+egCJaqF6K0BgR4yNT9PPmWneJHs7SR1v5hRR2uow9v0iIiv+rRfq/dT8q9VfFn4iXNJAOKyTPA3Kcnlxq0JYp52AQqwe1BpBLfsUgHOJhSJdtTcmhUfCtWzm2fATNwiNgnY4kXyLXatqE3Fz8cBHTr3sCq3k5rhoSbXfsNRvyd6N71PZdL+6wmiY1cReoIdnvRdU+y1apzxWM6iQI3a5A/L3UctHOFb5sdKEVcJDk2NPXWjFS7M43eyWkg2xFPjoQBVkB/X8PDSD1Pwzr12cw1e5UJLF62kSOsrSRrvkoEu2YOrtacBv6+J2BBuMH6+1cJqNJdN8fi9mw77fzba1vqcHF6uoQDaG9GYcRltGgsfj6Z/q/P0z0waanQzFYzTwt5blzitCpXlfJ4F1lk2C0AH2u6Y/5iKRs37hhM2lKkPPWLdPg3K8gMiToeoC7bK3dmE8Hg0J591wi/gXESDW6RUfmK8bn0wKaMcIbvhm28Kec8v66GlI4/0e4zxWyK+B/0W7U93vVfjdmlbKtdhp0cmBU7dwlrd+nSfoum7h0yEXnaTJfMB/zw5x+/m3bxuBkj7tJcCKpqPuWilP91WxvNCubKUHmCrVfvF60hyo/+zVlEeZO2QCbVewVvoPdprVbVuMkgAuhrojc9m1ZbxkvfKHO3GPmZ5eQ"
`endif