// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps //RG commented
// baeckler - 07-12-2014
// DESCRIPTION
// Wrapper for MLAB hardware cells in typical arrangement

module directphy_f_mlab #(
	parameter WIDTH = 20,
	parameter ADDR_WIDTH = 5,
	parameter SIM_EMULATE = 1'b0   // this may not be exactly the same at the fine grain timing level 
)
(
	input wclk,
	input wena,
	input [ADDR_WIDTH-1:0] waddr_reg,
	input [WIDTH-1:0] wdata_reg,
	input [ADDR_WIDTH-1:0] raddr,
	output [WIDTH-1:0] rdata		
);

genvar i;
generate
	if (!SIM_EMULATE) begin
        /////////////////////////////////////////////
        // hardware cells

        // the fourteen nm only (the Stratix 10) needs another data register
       // reg [WIDTH-1:0] wdata_reg_2 /* synthesis preserve */;
       // always @(posedge wclk) wdata_reg_2 <= wdata_reg;


		for (i=0; i<WIDTH; i=i+1)  begin : ml
			wire wclk_w = wclk;  // workaround strange modelsim warning due to cell model tristate
            // Note: the stratix 5 cell is the same other than timing
			//stratixv_mlab_cell lrm (
                        tennm_mlab_cell lrm (
				.clk0(wclk_w),
				.ena0(wena),
				
				// synthesis translate_off
				.clk1(1'b0),
				.ena1(1'b1),
				//.ena2(1'b1),
				.clr(1'b0),
				.devclrn(1'b1),
				.devpor(1'b1),
				// synthesis translate_on			

				.portabyteenamasks(1'b1),
				//.portadatain(wdata_reg_2[i]),
				.portadatain(wdata_reg[i]),
				.portaaddr(waddr_reg),
				.portbaddr(raddr),
				.portbdataout(rdata[i])			
				
			);

			defparam lrm .mixed_port_feed_through_mode = "dont_care";
			defparam lrm .logical_ram_name = "lrm";
			defparam lrm .logical_ram_depth = 1 << ADDR_WIDTH;
			defparam lrm .logical_ram_width = WIDTH;
			defparam lrm .first_address = 0;
			defparam lrm .last_address = (1 << ADDR_WIDTH)-1;
			defparam lrm .first_bit_number = i;
			defparam lrm .data_width = 1;
			defparam lrm .address_width = ADDR_WIDTH;
		end
	end
	else begin
		/////////////////////////////////////////////
		// sim equivalent

		localparam NUM_WORDS = (1 << ADDR_WIDTH);
		reg [WIDTH-1:0] storage [0:NUM_WORDS-1];
		integer k = 0;
		initial begin
			for (k=0; k<NUM_WORDS; k=k+1) begin
				storage[k] = 0;
			end
		end

		always @(posedge wclk) begin
			if (wena) storage [waddr_reg] <= wdata_reg;	
		end

		reg [WIDTH-1:0] rdata_b = 0;
		always @(*) begin
			rdata_b = storage[raddr];
		end
		
		assign rdata = rdata_b;
	end
	
endgenerate

endmodule	

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRx5UfYLyl868r4FGU1l/c9okUnED4jhaKhSxdgw42G1rNnwfb89p5tilW0fokurJYBcoAeTBID/s3eWjmpSPefOeiwe0tf4CRQbueZo0yyc7c6CBxJRMy0Ace6S2ZFKJzG418BPA3UbtGzB067UogL/dNnSy+A8iUzMWHQ9I2cd/k6NjAJ7nlQTfmitygaSdk4z8MRbFe0hfKjvY+iE3zsWBAcrSiJYyHWZZqCA9AewjAFo21rS/QJAfqX1NMiKYvjpyvAG6r9eU7RABVoe93zHzf1LcIzPmEET1FyQbQlJV4VNCoWvIGS9Xp0ncaTOJbIx7KFrUikLV0mPD+Xz91ArtkyWYZa82m+ChkDtJRIZONyyL/HuJQNYLWGHUpwvu0gHWGkhF+ddpF1MAzS3ty6LR6xgS1BPcsRpnZN256KE6kgltOgXn/Lks5jVOtn7+j9Lkgv91Ly6uYn391HqGk2VjtC8veu6ZXvS2doUls/xcDDAUhU4tSF6OIo0eykjoOm2odIXHQxx23u/zt0jKrX8GKdh99EI/0lnflAjgH64NcTDq7S1i944MKmhh76W7DKtzZqprnnuJ32Y2FMRCLOIqcnsWp9adOy+8ZHaZcEf/gCJyXk2XmU+bHQMaZOujDMbphgbLcd64vfjz7RUBv8+tkc57UzBVlgkuW0isJ7LkbAVBOwfXU6ZQ9pHGAeAWmEfpnKEEZIEBr4wiNYz9DdZh8/CVyWR6qFQV9MOx+vnhMR3GHIV5cDVaJ5Hevo/6uLl2fzIO1x/t35x1jhv9k4R"
`endif