// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module directphy_f_rx_deskew #(
    parameter WIDTH         = 64,
    parameter LANES         = 2,
    parameter SIM_EMULATE   = 0
) (
    input   logic                           i_clk,
    input   logic                           i_reset,
    input   logic [0:LANES-1][WIDTH-1:0]    i_data,
    input   logic [0:LANES-1]               i_sync_pulse,
    output  logic [0:LANES-1][WIDTH-1:0]    o_data,
    output  logic                           o_deskew_done
);

    logic   initial_sync_received;
    logic   [15:0]  startup_timer;
    logic           ready;

    logic   [15:0]              gap_timer;
    logic   [0:LANES-1]         incr_delay;
    logic   [0:LANES-1]         incr_delay_masked;
    logic   [0:LANES-1][2:0]    delay;
    logic   [0:LANES-1]         sync_pulses_delay;


    always_ff @(posedge i_clk) begin
        if (i_reset) begin
            initial_sync_received   <= 1'b0;
        end else begin
            initial_sync_received   <= initial_sync_received | (|i_sync_pulse);//RG added paranthesis to make spyglass happy
        end 

        if (i_reset) begin
            startup_timer           <= 16'b0;
        end else begin
            startup_timer           <= {initial_sync_received, startup_timer[14:1]};
        end

        if (i_reset) begin
            gap_timer           <= 16'b0;
        end else begin
            if (sync_pulses_delay) begin
                gap_timer           <= 16'b0;
            end else begin
                gap_timer           <= {1'b1, gap_timer[14:1]};
            end
        end

        if (i_reset) begin
            incr_delay  <= {LANES{1'b0}};
        end else begin
            if (gap_timer[0]) begin
                case (sync_pulses_delay)
                    {LANES{1'b0}}   : incr_delay    <= {LANES{1'b0}};
                    {LANES{1'b1}}   : incr_delay    <= {LANES{1'b0}};
                    default         : incr_delay    <= sync_pulses_delay;
                endcase
            end else begin
                incr_delay    <= {LANES{1'b0}};
            end
        end

        if (i_reset) begin
            incr_delay_masked   <= {LANES{1'b0}};
        end else begin
            if (ready) begin
                incr_delay_masked    <= incr_delay;
            end else begin
                incr_delay_masked   <= {LANES{1'b0}};
            end
        end

        if (i_reset) begin
            o_deskew_done   <= 1'b0;
        end else begin
            o_deskew_done   <= o_deskew_done || &sync_pulses_delay;
        end

    end

    assign ready = startup_timer[0];

    genvar i;
    generate
        for (i = 0; i < LANES; i++) begin : lane_loop

            directphy_f_word_delay #(
                .WIDTH       (WIDTH+1),
                .SIM_EMULATE (SIM_EMULATE)
            ) lane_delay (
                .i_clk      (i_clk),
                .i_reset    (i_reset),
                .i_delay    (delay[i]),
                .i_data     ({i_sync_pulse[i], i_data[i]}),
                .o_data     ({sync_pulses_delay[i], o_data[i]})
            );

            always_ff @(posedge i_clk) begin
                if (i_reset) begin
                    delay[i]    <= 3'd2;  // 2 is minimum delay
                end else begin
                    delay[i]    <= 3'(delay[i] + incr_delay_masked[i]);//RG added width
                end
            end
        end
    endgenerate

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRxPmj0vAHmaN525eg1yThaZHn9Rk8ajjAvxWD1iz0YRljPxTCbYMCIKJGfrIBk+1uQUPuEtFSm0BPBvTT07zTi/dSJ30QRhqLpsbMZk3Taqjb8F1tnHCzCqmOQ7DQLAUMO0uXWQPwdndk1dUSZ8S3SBRGWFBUUd0hKpglGj9qJv7uFa/IgwFKLZ3kfUok0QZTss/R0DlcU5uXtM6N0f2CKak4aXL2P1RtqZ4t5hX5nA8V3grdDnKPWakI4vTWvZjN+tCz1madr6dCJ6wWcGEbYEpJxJ5I1vT2Jf5owJZ4EGJvpfn9ahDpm74yZK8RLp5ru+dqTcq4yahJMzKFYd0p1w4srAc6oYsJ/jawu5FDhMQu8xo7/y3iSjBAktwXGNmp2amBInWQVL1VI8rYBSSrCfBJSqSYtf0eOw0HWvHJIHFTQgi7OLsUOOwXWf65BoY3mh3YrsrHiq5lk2ZZPewoyvOGHuEAe4RTPFhNBwXvMwE8TZ8jRZXAOk7X6vIx0cvD/+kiAEIsBYj8e3GlbK4ztFoW7Uw9QhUEqpt2qtxo1U2PmND90WdxXw7nCesPv8Ts6FagmuR2ZVni3zU3eoOlyvWHyRKt08LN8nCgYhyU21mD9rjvW0laCiLrXlVL0cEh+NMsLPzVmSkiME8l7nDAOHVv1CvIQ5LDDMWlzLuP7yptqF9st+y/W1R+C3VAyrzMS7HdfWrrkHBnot0m+ak8bIEGYlAVBEjCWV60pY2alOaeRX2pij2dZcMG1k+ZW6Xyi40gXLxLFiLnGhwIHDI68X"
`endif