// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module dphy_f_tx_dsk_gen 
  #(
    parameter WIDTH         = 64,
    parameter LANES         = 2,
 //   parameter SYS_COP       = 1,
    parameter FEC_ON       = 1,
    parameter FEC_MODE       = "IEEE 802.3 RS(528,514) (CL 91,KR)",
    parameter DOUBLE_WIDTH_ON   = 1,
    parameter tuning_hint  ="TX_TUNING_HINT_DISABLED",
    parameter pma_lanes  = 1,
    parameter pma_width  = 32
    )(
      input logic 		     i_clk,
 //   input   logic [SYS_COP-1:0]        i_reset,
      input logic [LANES*WIDTH-1:0]  i_data,
      output logic [LANES*WIDTH-1:0] o_data
      );
//For RSFEC patterns, tx deskew pulses are matching with the valid counts for
//each RSFEC mode. It's either 32 or 16 based on modes.
// 16 -> LLFEC or KP(544,514), tx deskew pulses are toggling every 16 cycles
// 32 -> KR(528,514),tx deskew pulses are toggling every 32 cycles.
// 16 means counter counts up to 15, so [3:0], WIDTH_CNT = 4.
// 32 means counter counts up to 31, so [4:0], WIDTH_CNT = 5
//
// For PMA patterns, tx deskew pulses are generated every 32 cycles.
   localparam WIDTH_CNT = FEC_ON ? 
			  (((FEC_MODE == "IEEE 802.3 RS(528,514) (CL 91,KR)") || 
	                    (FEC_MODE == "Ethernet Consortium RS(528,514)") || 
		            (FEC_MODE == "FC RS(528,514)") ||
		            (FEC_MODE == "FlexO RS(528,514)")) ? 5 : 4)
     : 5;
   
   logic [WIDTH_CNT-1:0] 	     counter = 'b0;
   logic 			     tx_dsk_pulse;
   assign tx_dsk_pulse = &counter;
   always @ (posedge i_clk) begin : increment_deskew_counter
      counter <= counter + 1'b1;
   end : increment_deskew_counter
generate
   genvar l;
   for(l=0;l<LANES;l=l+1)  begin:lane
      assign o_data[l*80+:80] = DOUBLE_WIDTH_ON ? {i_data[l*80+79], tx_dsk_pulse, i_data[l*80+:78]} : ((tuning_hint == "TX_TUNING_HINT_GPON" )&& (pma_lanes == 1) && (pma_width <=32)) ? {i_data[l*80+79 : l*80+37], 1'b0, i_data[l*80+:36]}  : {i_data[l*80+79 : l*80+37], tx_dsk_pulse, i_data[l*80+:36]};
   end : lane

endgenerate
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "EuDK9zG4ugiX6bYeG9fkF8FUFwPRbgVIE6SygcJWoXuuaS4/+tL/ICR9sNx6uB3Kj3mUnIREp4mwUwZMubvTqsZcZoX0L/B5JV5k+lHdxdt62kmOijVOFdzJpnqmAVvPH7A96JSBQK9foFtswKYNvQUQ2+CWOyvTAMYEcYud/KOqbMyKXMgXytIkjKbvFb0Btu42lszADoIzluQfKUm8UY0h+KnrrRgSFDhz2POB1v3IYpePP2x+rwXExeCv+rDspLbI3EIAX38P1rSo0IY9hHusMqkngUw28qMlp08MlaFKZ/qyJNDUcqcLrlw67PX+mlXRPj4Bs3AxykMOzZ5G6xNPjiHrkIUJPjVJFPQ/287+Z4V1Etch3nMTIcI9htzBAIICQb8fBnq9PRX//n5t3TLpxnWf2Xk32n3IEe+Dt/EkT4FvHdMU/oV3AwOVXl7VwNSm8z22K2lZ2ndcu5z2866Lta50ndtZx553BrOVn99j7YNTCNd55Wo3ER+vur706EUwW5/GQtrUW8VepeXwhefGOa8qs+uVuV07Qo/yk6TbUCtTkBZxzIPqMkrsg9gsnMhnK1+vXVJZE+xnEx3v5n4jEQSuMz7vneTDZmBibF73rMDC+fQwBZgsE21PRZ5rPS5OlMfcgTV2r0HCa5D718/tRKwGnGFw6KfO7fA8lo8uPM9TxvbZoZqt1zrdKghUwFtIbSS+L2/ySknU4jSJlLnsQbYGSiyXmv+ilkre855PB/RY+YiJf9ZJCZEpW9yiVQMu2HNIkCNDyt7mrscdG6ACbuvFS62aqq1Vadf+5xFLifyrH1M/J1u/Y0ykI9Mt97pjbKoDQZ9ysBAwS6Bt4Qw4cKBhcegZRBlZKZzQj2kxc11HeipXhUJYMOJ02r1zz/yJg0OeAPHiAY/W9zV0I9NTZGiyjdzzrk+uYiiTUlxuZprdEZrlZ73HW0t4smyv0k/pPAU/k4Irx6wGMlw2UDh33559Qjb3sJPZLvw+Xs0SQrD/qDfWE5fSN9fiSMz6"
`endif