module sdi_mr_tx_sys_tx_phy (
		input  wire        tx_pll_refclk_link,  //  tx_pll_refclk_link.clk,              This is neither a physical nor a logical pin. The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  system_pll_clk_link, // system_pll_clk_link.clk,              This is virtual representation of System PLL output clock. This is neither physical nor logical pin. The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  tx_reset,            //            tx_reset.tx_reset,         TX reset input for TX XCVRs and TX datapath. Must be kept asserted until tx_reset_ack is asserted.
		output wire [0:0]  tx_reset_ack,        //        tx_reset_ack.tx_reset_ack,     TX fully in reset indicator.
		output wire [0:0]  tx_ready,            //            tx_ready.tx_ready,         Status port to indicate when TX XCVRs and TX datapath are reset successfully and ready for data transfer.
		input  wire        tx_coreclkin,        //        tx_coreclkin.clk,              TX parallel clock input.
		output wire        tx_clkout,           //           tx_clkout.clk,              Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire        tx_clkout2,          //          tx_clkout2.clk,              Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire [0:0]  tx_cadence,          //          tx_cadence.tx_cadence,       This signal indicates the rate at which tx_datavalid pin needs to be asserted/deasserted when system is running at a higher clock rate then PMA word/bond clock.
		input  wire [0:0]  tx_cadence_fast_clk, // tx_cadence_fast_clk.clk,              Fast clock input for tx_cadence generator. This clock should be the system clock used withing F-Tile (or (system clock)/2 when Core Interface is in double width mode).
		input  wire [0:0]  tx_cadence_slow_clk, // tx_cadence_slow_clk.clk,              Slow clock input for tx_cadence generator. This clock should be the PMA word/bond clock (or (PMA word/bond clock)/2 when Core Interface is in double width mode).
		output wire [0:0]  tx_serial_data,      //      tx_serial_data.tx_serial_data,   TX serial data port.
		output wire [0:0]  tx_serial_data_n,    //    tx_serial_data_n.tx_serial_data_n, Differential pair for TX serial data port. Historically was hidden; however now used in pam4 signal simulation model, hence needs to be connected by user.
		output wire [0:0]  tx_pll_locked,       //       tx_pll_locked.tx_pll_locked,    Locked to reference clock within the PPM threshold status signal for fast/medium or slow PLL. 1`b1 - locked. 1'b0 - not locked. Applicable to both FGT and FHT transceivers.
		input  wire [79:0] tx_parallel_data     //    tx_parallel_data.tx_parallel_data, TX parallel data.
	);
endmodule

