// sdi_mr_tx_sys_tx_phy.v

// Generated using ACDS version 23.4 79

`timescale 1 ps / 1 ps
module sdi_mr_tx_sys_tx_phy (
		input  wire        tx_pll_refclk_link,  //  tx_pll_refclk_link.clk,              This is neither a physical nor a logical pin. The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  system_pll_clk_link, // system_pll_clk_link.clk,              This is virtual representation of System PLL output clock. This is neither physical nor logical pin. The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  tx_reset,            //            tx_reset.tx_reset,         TX reset input for TX XCVRs and TX datapath. Must be kept asserted until tx_reset_ack is asserted.
		output wire [0:0]  tx_reset_ack,        //        tx_reset_ack.tx_reset_ack,     TX fully in reset indicator.
		output wire [0:0]  tx_ready,            //            tx_ready.tx_ready,         Status port to indicate when TX XCVRs and TX datapath are reset successfully and ready for data transfer.
		input  wire        tx_coreclkin,        //        tx_coreclkin.clk,              TX parallel clock input.
		output wire        tx_clkout,           //           tx_clkout.clk,              Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire        tx_clkout2,          //          tx_clkout2.clk,              Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire [0:0]  tx_cadence,          //          tx_cadence.tx_cadence,       This signal indicates the rate at which tx_datavalid pin needs to be asserted/deasserted when system is running at a higher clock rate then PMA word/bond clock.
		input  wire [0:0]  tx_cadence_fast_clk, // tx_cadence_fast_clk.clk,              Fast clock input for tx_cadence generator. This clock should be the system clock used withing F-Tile (or (system clock)/2 when Core Interface is in double width mode).
		input  wire [0:0]  tx_cadence_slow_clk, // tx_cadence_slow_clk.clk,              Slow clock input for tx_cadence generator. This clock should be the PMA word/bond clock (or (PMA word/bond clock)/2 when Core Interface is in double width mode).
		output wire [0:0]  tx_serial_data,      //      tx_serial_data.tx_serial_data,   TX serial data port.
		output wire [0:0]  tx_serial_data_n,    //    tx_serial_data_n.tx_serial_data_n, Differential pair for TX serial data port. Historically was hidden; however now used in pam4 signal simulation model, hence needs to be connected by user.
		output wire [0:0]  tx_pll_locked,       //       tx_pll_locked.tx_pll_locked,    Locked to reference clock within the PPM threshold status signal for fast/medium or slow PLL. 1`b1 - locked. 1'b0 - not locked. Applicable to both FGT and FHT transceivers.
		input  wire [79:0] tx_parallel_data     //    tx_parallel_data.tx_parallel_data, TX parallel data.
	);

	sdi_mr_tx_sys_tx_phy_directphy_f_470_jhttwei #(
		.silicon_revision                                    ("10nm8agdrb"),
		.device_revision                                     ("10nm8agdrb"),
		.fgt_tx_pll_manual_enable                            (0),
		.fgt_tx_pll_cascade_enable                           (0),
		.fgt_tx_pll_frac_mode_enable                         (0),
		.fgt_rx_pll_manual_enable                            (0),
		.bb_f_ux_tx_pll                                      ("TX_PLL_MED"),
		.bb_f_ux_tx_pll_bw_sel                               ("TX_PLL_BW_SEL_MEDIUM"),
		.bb_f_ux_synth_lc_fast_f_out_hz                      ("0"),
		.bb_f_ux_synth_lc_fast_f_vco_hz                      ("0"),
		.bb_f_ux_synth_lc_fast_f_ref_hz                      (0),
		.bb_f_ux_synth_lc_fast_fractional_en                 ("__BB_DONT_CARE__"),
		.bb_f_ux_synth_lc_fast_k_counter                     (0),
		.bb_f_ux_synth_lc_fast_l_counter                     (0),
		.bb_f_ux_synth_lc_fast_m_counter                     (0),
		.bb_f_ux_synth_lc_fast_n_counter                     (0),
		.bb_f_ux_synth_lc_fast_primary_use                   ("__BB_DONT_CARE__"),
		.bb_f_ux_synth_lc_med_f_out_hz                       ("5940000000"),
		.bb_f_ux_synth_lc_med_f_vco_hz                       ("11880000000"),
		.bb_f_ux_synth_lc_med_f_ref_hz                       (148500000),
		.bb_f_ux_synth_lc_med_fractional_en                  ("DISABLE"),
		.bb_f_ux_synth_lc_med_k_counter                      (0),
		.bb_f_ux_synth_lc_med_l_counter                      (2),
		.bb_f_ux_synth_lc_med_m_counter                      (80),
		.bb_f_ux_synth_lc_med_n_counter                      (1),
		.bb_f_ux_synth_lc_med_primary_use                    ("SYNTH_LC_med_PRIMARY_USE_DISABLED"),
		.bb_f_ux_synth_lc_slow_f_out_hz                      ("0"),
		.bb_f_ux_synth_lc_slow_f_vco_hz                      ("0"),
		.bb_f_ux_synth_lc_slow_f_ref_hz                      (0),
		.bb_f_ux_synth_lc_slow_fractional_en                 ("__BB_DONT_CARE__"),
		.bb_f_ux_synth_lc_slow_k_counter                     (0),
		.bb_f_ux_synth_lc_slow_l_counter                     (0),
		.bb_f_ux_synth_lc_slow_m_counter                     (0),
		.bb_f_ux_synth_lc_slow_n_counter                     (0),
		.bb_f_ux_synth_lc_slow_primary_use                   ("__BB_DONT_CARE__"),
		.bb_f_ux_cdr_bw_sel                                  ("CDR_BW_SEL_LOW"),
		.bb_f_ux_cdr_f_out_hz                                ("0"),
		.bb_f_ux_cdr_f_vco_hz                                ("0"),
		.bb_f_ux_cdr_f_ref_hz                                (0),
		.bb_f_ux_cdr_l_counter                               (1),
		.bb_f_ux_cdr_m_counter                               (1),
		.bb_f_ux_cdr_n_counter                               (1),
		.bb_f_ux_synth_lc_fast_rx_postdiv_counter            (0),
		.bb_f_ux_synth_lc_med_rx_postdiv_counter             (0),
		.bb_f_ux_synth_lc_slow_rx_postdiv_counter            (0),
		.bb_f_ux_synth_lc_fast_f_rx_postdiv_hz               (0),
		.bb_f_ux_synth_lc_med_f_rx_postdiv_hz                (0),
		.bb_f_ux_synth_lc_slow_f_rx_postdiv_hz               (0),
		.bb_f_ux_tx_fb_div_emb_mult_counter                  (1),
		.targettype_bb_f_ux_tx_pll                           ("TX_PLL_FAST"),
		.targettype_bb_f_ux_tx_pll_bw_sel                    ("TX_PLL_BW_SEL_LOW"),
		.targettype_bb_f_ux_synth_lc_fast_f_out_hz           ("0"),
		.targettype_bb_f_ux_synth_lc_fast_f_vco_hz           ("0"),
		.targettype_bb_f_ux_synth_lc_fast_f_ref_hz           (0),
		.targettype_bb_f_ux_synth_lc_fast_fractional_en      ("DISABLED"),
		.targettype_bb_f_ux_synth_lc_fast_k_counter          (0),
		.targettype_bb_f_ux_synth_lc_fast_l_counter          (2),
		.targettype_bb_f_ux_synth_lc_fast_m_counter          (2),
		.targettype_bb_f_ux_synth_lc_fast_n_counter          (2),
		.targettype_bb_f_ux_synth_lc_fast_primary_use        ("SYNTH_LC_FAST_PRIMARY_USE_DISABLED"),
		.targettype_bb_f_ux_synth_lc_med_f_out_hz            ("0"),
		.targettype_bb_f_ux_synth_lc_med_f_vco_hz            ("0"),
		.targettype_bb_f_ux_synth_lc_med_f_ref_hz            (0),
		.targettype_bb_f_ux_synth_lc_med_fractional_en       ("DISABLED"),
		.targettype_bb_f_ux_synth_lc_med_k_counter           (0),
		.targettype_bb_f_ux_synth_lc_med_l_counter           (2),
		.targettype_bb_f_ux_synth_lc_med_m_counter           (2),
		.targettype_bb_f_ux_synth_lc_med_n_counter           (2),
		.targettype_bb_f_ux_synth_lc_med_primary_use         ("SYNTH_LC_FAST_PRIMARY_USE_DISABLED"),
		.targettype_bb_f_ux_synth_lc_slow_f_out_hz           ("0"),
		.targettype_bb_f_ux_synth_lc_slow_f_vco_hz           ("0"),
		.targettype_bb_f_ux_synth_lc_slow_f_ref_hz           (0),
		.targettype_bb_f_ux_synth_lc_slow_fractional_en      ("DISABLED"),
		.targettype_bb_f_ux_synth_lc_slow_k_counter          (0),
		.targettype_bb_f_ux_synth_lc_slow_l_counter          (2),
		.targettype_bb_f_ux_synth_lc_slow_m_counter          (2),
		.targettype_bb_f_ux_synth_lc_slow_n_counter          (2),
		.targettype_bb_f_ux_synth_lc_slow_primary_use        ("SYNTH_LC_FAST_PRIMARY_USE_DISABLED"),
		.targettype_bb_f_ux_tx_fb_div_emb_mult_counter       (2),
		.num_sys_cop                                         (1),
		.fgt_protocol_mode                                   ("SDI"),
		.num_xcvr_per_sys                                    (1),
		.duplex_mode                                         ("tx"),
		.pma_width                                           (20),
		.rx_deskew_en                                        (1),
		.enable_N_width_ready_signal                         (0),
		.enable_port_fgt_rx_cdr_divclk_link0                 (0),
		.fgt_rx_cdr_divclk_link0_sel                         (0),
		.enable_port_fgt_rx_cdr_divclk_link1                 (0),
		.fgt_rx_cdr_divclk_link1_sel                         (0),
		.l_num_aib_per_xcvr                                  (1),
		.l_num_hip_per_sys                                   (1),
		.l_sys_xcvrs                                         (1),
		.l_sys_xcvrs_cascade                                 (1),
		.l_sys_aibs                                          (1),
		.l_tx_enable                                         (1),
		.l_rx_enable                                         (0),
		.l_fec_mode                                          ("IEEE 802.3 RS(528,514) (CL 91,KR)"),
		.l_av1_enable                                        (0),
		.avmm1_readdv_enable                                 (0),
		.avmm1_split                                         (0),
		.avmm1_jtag_enable                                   (0),
		.l_av1_aib_enable                                    (0),
		.l_soft_csr_enable                                   (0),
		.l_num_avmm1                                         (1),
		.l_av1_ifaces                                        (1),
		.l_av1_addr_bits                                     (14),
		.l_line_rate_p1ghz                                   (119),
		.avmm2_enable                                        (0),
		.avmm2_readdv_enable                                 (0),
		.avmm2_split                                         (0),
		.avmm2_jtag_enable                                   (0),
		.l_num_avmm2                                         (1),
		.l_av2_ifaces                                        (1),
		.l_av2_addr_bits                                     (18),
		.enable_port_latency_measurement                     (0),
		.l_rx_deskew_enable                                  (1),
		.txparalleldata_width                                (80),
		.txsimpleinterface_enable                            (0),
		.cwbin_timeout_count                                 (1300),
		.enable_soft_cwbin                                   (0),
		.ready_width                                         (1),
		.bb_f_ehip_frac_size                                 ("F25G"),
		.bb_f_ehip_duplex_mode                               ("DUPLEX_MODE_SYSTEM_SIMPLEX"),
		.bb_f_ehip_fec_mode                                  ("FEC_MODE_DISABLED"),
		.bb_f_ehip_fec_spec                                  ("FEC_SPEC_DISABLED"),
		.bb_f_ehip_lpbk_mode                                 ("LPBK_MODE_DISABLED"),
		.bb_f_ehip_lphy_xcvrif_lpbk_en                       ("__BB_DONT_CARE__"),
		.bb_f_ehip_mac_mode                                  ("MAC_MODE_DISABLED"),
		.bb_f_ehip_rx_aib_if_fifo_mode                       ("RX_AIB_IF_FIFO_MODE_REGISTER"),
		.dec_bb_f_ehip_rx_datarate                           ("1000000000"),
		.bb_f_ehip_rx_en                                     ("FALSE"),
		.bb_f_ehip_rx_excvr_if_fifo_mode                     ("RX_EXCVR_IF_FIFO_MODE_ELASTIC"),
		.bb_f_ehip_rx_excvr_gb_ratio_mode                    ("RX_EXCVR_GB_RATIO_MODE_DISABLED"),
		.bb_f_ehip_rx_fec_enable                             ("RX_FEC_ENABLE_DISABLED"),
		.bb_f_ehip_rx_pcs_mode                               ("RX_PCS_MODE_DISABLED"),
		.bb_f_ehip_rx_primary_use                            ("RX_PRIMARY_USE_DIRECT_BUNDLE"),
		.bb_f_ehip_rx_total_xcvr                             (0),
		.bb_f_ehip_rx_xcvr_width                             ("RX_XCVR_WIDTH_8"),
		.bb_f_ehip_tx_pmadirect_single_width                 ("FALSE"),
		.bb_f_ehip_rx_pmadirect_single_width                 ("__BB_DONT_CARE__"),
		.bb_f_ehip_silicon_rev                               ("10nm8agdrb"),
		.bb_f_ehip_speed_map                                 ("SPEED_MAP_MAP_25G"),
		.bb_f_ehip_tx_aib_if_fifo_mode                       ("TX_AIB_IF_FIFO_MODE_PHASECOMP"),
		.dec_bb_f_ehip_tx_datarate                           ("11880000000"),
		.bb_f_ehip_tx_en                                     ("true"),
		.bb_f_ehip_tx_excvr_if_fifo_mode                     ("TX_EXCVR_IF_FIFO_MODE_ELASTIC"),
		.bb_f_ehip_tx_excvr_gb_ratio_mode                    ("TX_EXCVR_GB_RATIO_MODE_DISABLED"),
		.bb_f_ehip_tx_fec_enable                             ("TX_FEC_ENABLE_DISABLED"),
		.bb_f_ehip_tx_pcs_mode                               ("TX_PCS_MODE_DISABLED"),
		.bb_f_ehip_tx_primary_use                            ("TX_PRIMARY_USE_DIRECT_BUNDLE"),
		.bb_f_ehip_tx_total_xcvr                             (1),
		.bb_f_ehip_tx_xcvr_width                             ("TX_XCVR_WIDTH_20"),
		.bb_f_ehip_xcvr_mode                                 ("XCVR_MODE_NRZ"),
		.bb_f_ehip_xcvr_type                                 ("XCVR_TYPE_UX"),
		.bb_f_ehip_fec_clk_src                               ("__BB_DONT_CARE__"),
		.bb_f_ehip_sys_clk_src                               ("SYS_CLK_SRC_PLL"),
		.bb_f_ehip_aib2_rx_st_clk_en                         ("AIB2_RX_ST_CLK_EN_DISABLED"),
		.bb_f_ehip_aib2_tx_st_clk_en                         ("AIB2_TX_ST_CLK_EN_PLL_DIV2"),
		.bb_f_ehip_aib3_rx_st_clk_en                         ("AIB3_RX_ST_CLK_EN_DISABLED"),
		.bb_f_ehip_aib3_tx_st_clk_en                         ("AIB3_TX_ST_CLK_EN_TX_USER_CLK1"),
		.bb_f_ehip_fec_802p3ck                               ("DISABLE"),
		.bb_f_ehip_is_fec_part_of_reconfig                   ("false"),
		.bb_f_ux_flux_mode                                   ("FLUX_MODE_CPRI"),
		.bb_f_ux_core_pll                                    ("CORE_PLL_DISABLED"),
		.bb_f_ux_engineered_link_mode                        ("DISABLE"),
		.bb_f_ux_rx_adapt_mode                               ("RX_ADAPT_MODE_FLUX_RX_ADAPT"),
		.bb_f_ux_force_cdr_ltd                               ("DISABLE"),
		.bb_f_ux_force_cdr_ltr                               ("DISABLE"),
		.bb_f_ux_enable_port_control_of_cdr_ltr_ltd          ("DISABLE"),
		.bb_f_ux_rx_cdr_pll_l_counter                        (1),
		.bb_f_ux_rx_cdr_pll_n_counter                        (1),
		.bb_f_ux_rx_cdr_pll_postdiv_en                       ("RX_CDR_PLL_POSTDIV_EN_1"),
		.bb_f_ux_cdr_postdiv_counter                         (100),
		.bb_f_ux_cdr_postdiv_fractional_en                   ("DISABLE"),
		.bb_f_ux_cdr_f_postdiv_hz                            (37'b0000000000000000000000000000000000000),
		.bb_f_ux_synth_lc_fast_tx_postdiv_counter            (0),
		.bb_f_ux_synth_lc_med_tx_postdiv_counter             (40),
		.bb_f_ux_synth_lc_slow_tx_postdiv_counter            (0),
		.bb_f_ux_synth_lc_fast_tx_postdiv_fractional_en      ("DISABLE"),
		.bb_f_ux_synth_lc_med_tx_postdiv_fractional_en       ("DISABLE"),
		.bb_f_ux_synth_lc_slow_tx_postdiv_fractional_en      ("DISABLE"),
		.bb_f_ux_synth_lc_fast_f_tx_postdiv_hz               (37'b0000000000000000000000000000000000000),
		.bb_f_ux_synth_lc_med_f_tx_postdiv_hz                (37'b0000000010001101100111101110001000000),
		.bb_f_ux_synth_lc_slow_f_tx_postdiv_hz               (37'b0000000000000000000000000000000000000),
		.bb_f_ux_tx_user_clk1_en                             ("ENABLE"),
		.bb_f_ux_tx_user_clk2_en                             ("DISABLE"),
		.bb_f_ux_tx_user_clk1_mux                            ("TX_USER_CLK1_MUX_SLOW_MED"),
		.bb_f_ux_tx_user_clk2_mux                            ("TX_USER_CLK2_MUX_SLOW_MED"),
		.bb_f_ux_tx_user_clk_slow_med_mux                    ("TX_USER_CLK_SLOW_MED_MUX_MED"),
		.bb_f_ux_rx_user_clk_en                              ("DISABLE"),
		.bb_f_ux_fractional_mode                             ("OFF"),
		.bb_f_ux_digital_core_divider                        (0),
		.bb_f_ux_rx_clkdiv                                   (8),
		.bb_f_ux_tx_clkdiv                                   (8),
		.bb_f_ux_rx_protocol                                 ("RX_PROTOCOL_PMA_DIRECT_SYS_CLK"),
		.bb_f_ux_tx_protocol                                 ("TX_PROTOCOL_PMA_DIRECT_SYS_CLK"),
		.bb_f_ux_silicon_rev                                 ("10nm8agdrb"),
		.bb_f_ux_rx_width                                    ("RX_WIDTH_DISABLED"),
		.bb_f_ux_tx_width                                    ("TX_WIDTH_20"),
		.bb_f_ux_rx_bond_size                                ("RX_BOND_SIZE_1"),
		.bb_f_ux_tx_bond_size                                ("TX_BOND_SIZE_1"),
		.bb_f_ux_txrx_line_encoding_type                     ("TXRX_LINE_ENCODING_TYPE_NRZ"),
		.bb_f_ux_loopback_mode                               ("LOOPBACK_MODE_DISABLED"),
		.bb_f_ux_txrx_channel_operation                      ("TXRX_CHANNEL_OPERATION_DUAL_SIMPLEX"),
		.bb_f_ux_txrx_xcvr_speed_bucket                      ("TXRX_XCVR_SPEED_BUCKET_25G"),
		.bb_f_ux_squelch_detect                              ("DISABLE"),
		.bb_f_ux_prbs_gen_en                                 ("DISABLE"),
		.bb_f_ux_prbs_mon_en                                 ("DISABLE"),
		.bb_f_ux_prbs_pattern                                (0),
		.bb_f_ux_rx_pam4_graycode_en                         ("DISABLE"),
		.bb_f_ux_tx_pam4_graycode_en                         ("DISABLE"),
		.bb_f_ux_rx_pam4_precode_en                          ("DISABLE"),
		.bb_f_ux_tx_pam4_precode_en                          ("DISABLE"),
		.bb_f_ux_tx_tuning_hint                              ("TX_TUNING_HINT_SDI"),
		.bb_f_ux_rx_tuning_hint                              ("RX_TUNING_HINT_SDI"),
		.bb_f_ux_tx_spread_spectrum_en                       ("DISABLE"),
		.bb_f_aib_silicon_rev                                ("10nm8agdrb"),
		.bb_m_hdpldadapt_rx_fifo_width                       ("FIFO_DOUBLE_WIDTH"),
		.bb_f_bk_silicon_rev                                 ("10nm8agdrb"),
		.bb_f_bk_package_type                                ("HIGHEND"),
		.bb_f_bk_speed_grade                                 ("SPEED_GRADE_112G"),
		.bb_f_bk_sup_mode                                    ("SUP_MODE_USER_MODE"),
		.bb_f_bk_tx_protocol                                 ("TX_PROTOCOL_PMA_DIRECT_SYS_CLK"),
		.bb_f_bk_tx_bond_size                                ("TX_BOND_SIZE_1"),
		.bb_f_bk_tx_line_rate                                (37'b0001011000100000110100110101000000000),
		.bb_f_bk_txrx_line_encoding_type                     ("TXRX_LINE_ENCODING_TYPE_NRZ"),
		.bb_f_bk_txout_tristate_en                           ("TXOUT_TRISTATE_DIS"),
		.bb_f_bk_tx_termination                              ("TXTERM_OFFSET_P0"),
		.bb_f_bk_tx_invert_p_and_n                           ("TX_INVERT_PN_DIS"),
		.bb_f_bk_pam4_rxgrey_code                            ("PAM4_RXGREY_IS_B4"),
		.bb_f_bk_refclk_source_lane_pll                      ("REF_TO_GND"),
		.bb_f_bk_pll_pcs3334_ratio                           ("DIV_33_BY_2"),
		.bb_f_bk_pll_rx_pcs3334_ratio                        ("RX_DIV_33_BY_2"),
		.bb_f_bk_rx_user_clk1_en                             ("RX_USRCLK1_DIS"),
		.bb_f_bk_rx_user_clk2_en                             ("RX_USRCLK2_DIS"),
		.bb_f_bk_rx_user_clk1_sel                            ("RX_USRCLK1SEL_DIV3334"),
		.bb_f_bk_rx_user_clk2_sel                            ("RX_USRCLK2SEL_DIV3334"),
		.bb_f_bk_tx_user_clk1_en                             ("TX_USRCLK1_DIS"),
		.bb_f_bk_tx_user_clk2_en                             ("TX_USRCLK2_DIS"),
		.bb_f_bk_tx_user_clk1_sel                            ("TX_USRCLK1SEL_DIV3334"),
		.bb_f_bk_tx_user_clk2_sel                            ("TX_USRCLK2SEL_DIV3334"),
		.bb_f_bk_an_mode                                     ("AN_MODE_DIS"),
		.bb_f_bk_bk_dl_enable                                ("DETLAT_DIS"),
		.bb_f_bk_loopback_mode                               ("LPBK_DISABLED"),
		.bb_f_bk_bti_protected                               ("FALSE"),
		.bb_f_bk_rx_termination                              ("RXTERM_OFFSET_P0"),
		.bb_f_bk_rx_invert_p_and_n                           ("RX_INVERT_PN_DIS"),
		.bb_f_bk_bk_en_rxdat_profile                         ("RXDAT_PROF_EN"),
		.bb_f_bk_bk_rx_lat_bit_for_async                     (0),
		.bb_f_bk_bk_rxbit_cntr_pma                           ("RXBIT_CNTR_PMADIR_EN"),
		.bb_f_bk_bk_rxbit_rollover                           (5248),
		.bb_f_bk_rx_precode_en                               ("RX_PRECODE_DIS"),
		.bb_f_bk_tx_precode_en                               ("TX_PRECODE_DIS"),
		.bb_f_bk_pll_n_counter                               (1),
		.bb_f_aib_aibadapt_rx_rx_user_clk_sel                ("AIBADAPT_RX_RX_USER_CLK_EHIP"),
		.bb_f_aib_aibadapt_tx_tx_user_clk_sel                ("AIBADAPT_TX_TX_USER_CLK_EHIP_DIV2"),
		.bb_f_aib_aib_hssi_rx_transfer_clk_hz                (900000000),
		.bb_f_aib_aib_hssi_tx_transfer_clk_hz                (900000000),
		.bb_f_aib_aib_tx_user_clk_hz                         (148500000),
		.bb_f_aib_aib_rx_user_clk_hz                         (-1),
		.tx_custom_cadence_enable                            (1),
		.enable_port_tx_cadence_slow_clk_locked              (0),
		.pldif_tx_double_width_transfer_enable               (1),
		.pldif_tx_coreclkin_clock_network                    ("dedicated"),
		.pldif_tx_coreclkin2_clock_network                   ("dedicated"),
		.pldif_rx_double_width_transfer_enable               (1),
		.pldif_rx_coreclkin_clock_network                    ("dedicated"),
		.bb_m_hdpldadapt_rx_fifo_mode                        ("PHASE_COMP"),
		.bb_m_hdpldadapt_rx_pld_clk1_sel                     ("PLD_CLK1_DCM"),
		.bb_m_hdpldadapt_rx_hdpldadapt_speed_grade           ("HDPLDADAPT_DASH_2"),
		.bb_m_hdpldadapt_rx_rxfifo_pempty                    (2),
		.bb_m_hdpldadapt_rx_rxfifo_pfull                     (10),
		.bb_m_hdpldadapt_tx_duplex_mode                      ("ENABLE"),
		.bb_m_hdpldadapt_tx_fifo_mode                        ("PHASE_COMP"),
		.bb_m_hdpldadapt_tx_fifo_width                       ("FIFO_DOUBLE_WIDTH"),
		.bb_m_hdpldadapt_tx_pld_clk1_sel                     ("PLD_CLK1_DCM"),
		.bb_m_hdpldadapt_tx_pld_clk2_sel                     ("PLD_CLK2_DCM"),
		.bb_m_hdpldadapt_tx_hdpldadapt_speed_grade           ("HDPLDADAPT_DASH_2"),
		.bb_m_hdpldadapt_tx_txfifo_pempty                    (2),
		.bb_m_hdpldadapt_tx_txfifo_pfull                     (10),
		.bb_m_hdpldadapt_tx_tx_datapath_tb_sel               ("TX_FIFO_TB1"),
		.bb_m_hdpldadapt_rx_rx_datapath_tb_sel               ("PCS_CHNL_TB"),
		.bb_m_hdpldadapt_rx_hdpldadapt_pld_rx_clk1_dcm_hz    (450000000),
		.bb_m_hdpldadapt_rx_hdpldadapt_pld_rx_clk1_rowclk_hz (450000000),
		.bb_m_hdpldadapt_tx_hdpldadapt_pld_tx_clk1_dcm_hz    (450000000),
		.bb_m_hdpldadapt_tx_hdpldadapt_pld_tx_clk1_rowclk_hz (450000000),
		.bb_m_hdpldadapt_tx_hdpldadapt_pld_tx_clk2_dcm_hz    (450000000),
		.bb_m_hdpldadapt_tx_hdpldadapt_pld_tx_clk2_rowclk_hz (450000000)
	) tx_phy (
		.tx_pll_refclk_link          (tx_pll_refclk_link),                   //   input,   width = 1,  tx_pll_refclk_link.clk
		.system_pll_clk_link         (system_pll_clk_link),                  //   input,   width = 1, system_pll_clk_link.clk
		.tx_reset                    (tx_reset),                             //   input,   width = 1,            tx_reset.tx_reset
		.tx_reset_ack                (tx_reset_ack),                         //  output,   width = 1,        tx_reset_ack.tx_reset_ack
		.tx_ready                    (tx_ready),                             //  output,   width = 1,            tx_ready.tx_ready
		.tx_coreclkin                (tx_coreclkin),                         //   input,   width = 1,        tx_coreclkin.clk
		.tx_clkout                   (tx_clkout),                            //  output,   width = 1,           tx_clkout.clk
		.tx_clkout2                  (tx_clkout2),                           //  output,   width = 1,          tx_clkout2.clk
		.tx_cadence                  (tx_cadence),                           //  output,   width = 1,          tx_cadence.tx_cadence
		.tx_cadence_fast_clk         (tx_cadence_fast_clk),                  //   input,   width = 1, tx_cadence_fast_clk.clk
		.tx_cadence_slow_clk         (tx_cadence_slow_clk),                  //   input,   width = 1, tx_cadence_slow_clk.clk
		.tx_serial_data              (tx_serial_data),                       //  output,   width = 1,      tx_serial_data.tx_serial_data
		.tx_serial_data_n            (tx_serial_data_n),                     //  output,   width = 1,    tx_serial_data_n.tx_serial_data_n
		.tx_pll_locked               (tx_pll_locked),                        //  output,   width = 1,       tx_pll_locked.tx_pll_locked
		.tx_parallel_data            (tx_parallel_data),                     //   input,  width = 80,    tx_parallel_data.tx_parallel_data
		.rx_cdr_divclk_link0         (),                                     // (terminated),                                  
		.rx_cdr_divclk_link1         (),                                     // (terminated),                                  
		.rx_cdr_refclk_link          (1'b0),                                 // (terminated),                                  
		.rx_reset                    (1'b0),                                 // (terminated),                                  
		.rx_reset_ack                (),                                     // (terminated),                                  
		.tx_am_gen_start             (),                                     // (terminated),                                  
		.tx_am_gen_2x_ack            (1'b0),                                 // (terminated),                                  
		.rx_ready                    (),                                     // (terminated),                                  
		.rx_coreclkin                (1'b0),                                 // (terminated),                                  
		.rx_clkout                   (),                                     // (terminated),                                  
		.rx_clkout2                  (),                                     // (terminated),                                  
		.tx_coreclkin2               (1'b0),                                 // (terminated),                                  
		.tx_clkout_hioint            (),                                     // (terminated),                                  
		.tx_clkout2_hioint           (),                                     // (terminated),                                  
		.rx_clkout_hioint            (),                                     // (terminated),                                  
		.rx_clkout2_hioint           (),                                     // (terminated),                                  
		.tx_cadence_slow_clk_locked  (1'b0),                                 // (terminated),                                  
		.dl_clk                      (1'b0),                                 // (terminated),                                  
		.tx_dl_measure_sel           (1'b0),                                 // (terminated),                                  
		.rx_dl_measure_sel           (1'b0),                                 // (terminated),                                  
		.tx_dl_async_pulse           (),                                     // (terminated),                                  
		.rx_dl_async_pulse           (),                                     // (terminated),                                  
		.rx_serial_data              (1'b0),                                 // (terminated),                                  
		.rx_serial_data_n            (1'b0),                                 // (terminated),                                  
		.fgt_rx_signal_detect        (),                                     // (terminated),                                  
		.fgt_rx_signal_detect_lfps   (),                                     // (terminated),                                  
		.rx_is_lockedtodata          (),                                     // (terminated),                                  
		.rx_is_lockedtoref           (),                                     // (terminated),                                  
		.fgt_rx_set_locktoref        (1'b0),                                 // (terminated),                                  
		.fgt_rx_set_locktodata       (1'b0),                                 // (terminated),                                  
		.fgt_rx_cdr_freeze           (1'b0),                                 // (terminated),                                  
		.fgt_tx_beacon               (1'b0),                                 // (terminated),                                  
		.fgt_rx_cdr_fast_freeze_sel  (1'b0),                                 // (terminated),                                  
		.fgt_rx_cdr_set_locktoref    (1'b0),                                 // (terminated),                                  
		.tx_fifo_full                (),                                     // (terminated),                                  
		.tx_fifo_empty               (),                                     // (terminated),                                  
		.tx_fifo_pfull               (),                                     // (terminated),                                  
		.tx_fifo_pempty              (),                                     // (terminated),                                  
		.tx_dll_lock                 (),                                     // (terminated),                                  
		.rx_fifo_full                (),                                     // (terminated),                                  
		.rx_fifo_empty               (),                                     // (terminated),                                  
		.rx_fifo_pfull               (),                                     // (terminated),                                  
		.rx_fifo_pempty              (),                                     // (terminated),                                  
		.rx_fifo_rd_en               (1'b0),                                 // (terminated),                                  
		.rx_pmaif_fifo_empty         (),                                     // (terminated),                                  
		.rx_pmaif_fifo_pempty        (),                                     // (terminated),                                  
		.rx_pmaif_fifo_pfull         (),                                     // (terminated),                                  
		.tx_pmaif_fifo_empty         (),                                     // (terminated),                                  
		.tx_pmaif_fifo_pempty        (),                                     // (terminated),                                  
		.tx_pmaif_fifo_pfull         (),                                     // (terminated),                                  
		.rsfec_sf                    (),                                     // (terminated),                                  
		.rsfec_status_rx_not_align   (),                                     // (terminated),                                  
		.rsfec_status_rx_not_deskew  (),                                     // (terminated),                                  
		.rsfec_status_rx_not_locked  (),                                     // (terminated),                                  
		.fec_snapshot                (1'b0),                                 // (terminated),                                  
		.fgt_tx_pma_elecidle         (4'b0000),                              // (terminated),                                  
		.rx_parallel_data            (),                                     // (terminated),                                  
		.reconfig_xcvr_clk           (1'b0),                                 // (terminated),                                  
		.reconfig_xcvr_reset         (1'b0),                                 // (terminated),                                  
		.reconfig_xcvr_write         (1'b0),                                 // (terminated),                                  
		.reconfig_xcvr_read          (1'b0),                                 // (terminated),                                  
		.reconfig_xcvr_address       (18'b000000000000000000),               // (terminated),                                  
		.reconfig_xcvr_byteenable    (4'b0000),                              // (terminated),                                  
		.reconfig_xcvr_writedata     (32'b00000000000000000000000000000000), // (terminated),                                  
		.reconfig_xcvr_readdata      (),                                     // (terminated),                                  
		.reconfig_xcvr_waitrequest   (),                                     // (terminated),                                  
		.reconfig_xcvr_readdatavalid (),                                     // (terminated),                                  
		.reconfig_pdp_clk            (1'b0),                                 // (terminated),                                  
		.reconfig_pdp_reset          (1'b0),                                 // (terminated),                                  
		.reconfig_pdp_write          (1'b0),                                 // (terminated),                                  
		.reconfig_pdp_read           (1'b0),                                 // (terminated),                                  
		.reconfig_pdp_address        (14'b00000000000000),                   // (terminated),                                  
		.reconfig_pdp_byteenable     (4'b0000),                              // (terminated),                                  
		.reconfig_pdp_writedata      (32'b00000000000000000000000000000000), // (terminated),                                  
		.reconfig_pdp_readdata       (),                                     // (terminated),                                  
		.reconfig_pdp_waitrequest    (),                                     // (terminated),                                  
		.reconfig_pdp_readdatavalid  ()                                      // (terminated),                                  
	);

endmodule
