
namespace eval sdi_mr_tx_sys_tx_sdi {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries sdi_ii_tx_protocol_1940      1
    dict set libraries sdi_ii_tx_phy_mgmt_1940      1
    dict set libraries altera_reset_controller_1922 1
    dict set libraries sdi_ii_1940                  1
    dict set libraries sdi_mr_tx_sys_tx_sdi         1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR} {
    set memory_files [list]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [list]
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_tx_protocol.v"]\"  -work sdi_ii_tx_protocol_1940"      
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_hd_crc.v"]\"  -work sdi_ii_tx_protocol_1940"           
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_hd_insert_ln.v"]\"  -work sdi_ii_tx_protocol_1940"     
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_scrambler.v"]\"  -work sdi_ii_tx_protocol_1940"        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_transmit.v"]\"  -work sdi_ii_tx_protocol_1940"         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_vpid_insert.v"]\"  -work sdi_ii_tx_protocol_1940"      
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_trsmatch.v"]\"  -work sdi_ii_tx_protocol_1940"         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_sd_bits_conv.v"]\"  -work sdi_ii_tx_protocol_1940"     
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_protocol_1940/sim/mentor/src_hdl/sdi_ii_sync_bit_ins.v"]\"  -work sdi_ii_tx_protocol_1940"     
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_phy_mgmt_1940/sim/mentor/src_hdl/sdi_ii_tx_phy_mgmt.v"]\"  -work sdi_ii_tx_phy_mgmt_1940"      
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_phy_mgmt_1940/sim/mentor/src_hdl/sdi_ii_tx_sample.v"]\"  -work sdi_ii_tx_phy_mgmt_1940"        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_phy_mgmt_1940/sim/mentor/src_hdl/sdi_ii_tx_xcvr_interface.v"]\"  -work sdi_ii_tx_phy_mgmt_1940"
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_tx_phy_mgmt_1940/sim/mentor/src_hdl/sdi_ii_tx_ce_gen.v"]\"  -work sdi_ii_tx_phy_mgmt_1940"        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1922/sim/altera_reset_controller.v"]\"  -work altera_reset_controller_1922"      
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1922/sim/altera_reset_synchronizer.v"]\"  -work altera_reset_controller_1922"    
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../sdi_ii_1940/sim/sdi_mr_tx_sys_tx_sdi_sdi_ii_1940_fhdw4ri.v"]\"  -work sdi_ii_1940"                       
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/sdi_mr_tx_sys_tx_sdi.v"]\"  -work sdi_mr_tx_sys_tx_sdi"                                                     
    return $design_files
  }
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    
    return $libraries
  }
  
}
