// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module tx_mr_top #(
    parameter           NUM_STREAMS = 1,
    parameter           TXPLL_REFCLK_PWRUP_FREQ = "148.5",
    parameter [14:0]    MRPHY_TX_BASE_PROFILE = 15'd1
)(
    // System PLL Link clock
    input  logic                        system_pll_clk,
    // TX clocks
    input  logic                        sdi_tx_pclk,
    input  logic                        tx_pll_refclk,
    // TX Reference Reset
    input  logic                        sdi_tx_resetn,
    input  logic                        tx_phy_resetn,

    // TX Video Signal Interface (Could be Interface with CVO)
    input  logic [NUM_STREAMS*20-1:0]   tx_vid_data,
    input  logic                        tx_vid_datavalid,
    input  logic [2:0]                  tx_vid_std,
    input  logic                        tx_vid_trs,
    output logic                        tx_vid_clkout,
    // Other SDI TX Video Protocol Interfaces
    input  logic                        sdi_tx_enable_crc,
    input  logic                        sdi_tx_enable_ln,
    input  logic [NUM_STREAMS*11-1:0]   sdi_tx_ln,
    input  logic [NUM_STREAMS*11-1:0]   sdi_tx_ln_b,
    output logic                        sdi_tx_datavalid,

    // TX Transceiver Interface
    output logic                        tx_pll_locked,
    output logic                        gxb_tx_reset_ack,
    output logic                        gxb_tx_serial_data,
    output logic                        gxb_tx_serial_data_n,
    output logic                        gxb_tx_ready
);

// ----------------------
// Signal Declaration
// ----------------------
logic                       tx_syspll_clkout;
logic                       tx_cadence;
logic [NUM_STREAMS*20-1:0]  sdi_tx_dataout;
logic [79:0]                tx_parallel_data;

sdi_ftile_phy_adapter   #(
    .VIDEO_STANDARD ("mr"),
    .DIRECTION      ("tx")
) sdi_phy_adapter_inst (
// Input Clocks and reset
    .tx_resetn          (tx_phy_resetn),
    .tx_syspll_clkout   (tx_syspll_clkout),
    .tx_vid_clkout      (sdi_tx_pclk),
    .rx_resetn          (1'b0),
    .rx_syspll_clkout   (1'b0),
    .rx_vid_clkout      (1'b0),

// Inputs
    .gxb_tx_ready       (gxb_tx_ready),
    .tx_cadence         (tx_cadence),
    .sdi_txdata         (sdi_tx_dataout),
    .gxb_rx_ready       (1'b0),
    .rx_parallel_data   (80'd0),
    .rx_vid_std         (3'd0),

// Outputs
    .tx_parallel_data   (tx_parallel_data),
    .rxdata_to_sdi      ()
);

// ----------------------
// SDI Tx Core with PHY
// ----------------------
sdi_mr_tx_sys  sdi_mr_tx_sys_inst (
// Input Clocks and reset
    .tx_phy_tx_coreclkin_clk                            (tx_syspll_clkout),
    .tx_phy_tx_cadence_fast_clk_clk                     (tx_syspll_clkout),
    .tx_phy_tx_cadence_slow_clk_clk                     (sdi_tx_pclk),
    .tx_phy_system_pll_clk_link_clk                     (system_pll_clk),
    .tx_phy_tx_pll_refclk_link_clk                      (tx_pll_refclk),
    .tx_phy_tx_reset_tx_reset                           (~tx_phy_resetn),
    .tx_sdi_tx_pclk_clk                                 (sdi_tx_pclk),
    .tx_sdi_tx_rst_reset                                (~sdi_tx_resetn),

// Output clocks and reset
    .tx_phy_tx_clkout_clk                               (tx_syspll_clkout),
    .tx_phy_tx_clkout2_clk                              (tx_vid_clkout),
    .tx_phy_tx_reset_ack_tx_reset_ack                   (gxb_tx_reset_ack),

// Inputs
    .tx_sdi_tx_datain_valid_export                      (tx_vid_datavalid),
    .tx_sdi_tx_trs_export                               (tx_vid_trs),
    .tx_sdi_tx_enable_ln_export                         (sdi_tx_enable_ln),
    .tx_sdi_tx_enable_crc_export                        (sdi_tx_enable_crc),
    .tx_sdi_tx_datain_export                            (tx_vid_data),
    .tx_sdi_tx_ln_export                                (sdi_tx_ln),
    .tx_sdi_tx_ln_b_export                              (sdi_tx_ln_b),
    .tx_sdi_tx_std_export                               (tx_vid_std),
    .tx_phy_tx_parallel_data_tx_parallel_data           (tx_parallel_data),

// Outputs
    .tx_phy_tx_serial_data_tx_serial_data               (gxb_tx_serial_data),
    .tx_phy_tx_serial_data_n_tx_serial_data_n           (gxb_tx_serial_data_n),
    .tx_phy_tx_ready_tx_ready                           (gxb_tx_ready),
    .tx_phy_tx_cadence_tx_cadence                       (tx_cadence),
    .tx_phy_tx_pll_locked_tx_pll_locked                 (tx_pll_locked),
    .tx_sdi_tx_dataout_valid_export                     (sdi_tx_datavalid),
    .tx_sdi_tx_dataout_tx_parallel_data                 (sdi_tx_dataout)
);

endmodule

