source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_pio/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_tx_clkout/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_mm_clock_crossing_bridge/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_avmm_rst/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_avmm_clk/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_pattgen_rst/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/pattgen_ctrl/pattgen_ctrl_master/sim/common/riviera_files.tcl]

namespace eval pattgen_ctrl {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [pattgen_ctrl_pio::get_design_libraries]]
    set libraries [dict merge $libraries [pattgen_ctrl_tx_clkout::get_design_libraries]]
    set libraries [dict merge $libraries [pattgen_ctrl_mm_clock_crossing_bridge::get_design_libraries]]
    set libraries [dict merge $libraries [pattgen_ctrl_avmm_rst::get_design_libraries]]
    set libraries [dict merge $libraries [pattgen_ctrl_avmm_clk::get_design_libraries]]
    set libraries [dict merge $libraries [pattgen_ctrl_pattgen_rst::get_design_libraries]]
    set libraries [dict merge $libraries [pattgen_ctrl_master::get_design_libraries]]
    dict set libraries altera_merlin_master_translator_192 1
    dict set libraries altera_merlin_slave_translator_191  1
    dict set libraries altera_mm_interconnect_1920         1
    dict set libraries altera_reset_controller_1922        1
    dict set libraries pattgen_ctrl                        1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [pattgen_ctrl_pio::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pio/sim/"]]
    set memory_files [concat $memory_files [pattgen_ctrl_tx_clkout::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_tx_clkout/sim/"]]
    set memory_files [concat $memory_files [pattgen_ctrl_mm_clock_crossing_bridge::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_mm_clock_crossing_bridge/sim/"]]
    set memory_files [concat $memory_files [pattgen_ctrl_avmm_rst::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_rst/sim/"]]
    set memory_files [concat $memory_files [pattgen_ctrl_avmm_clk::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_clk/sim/"]]
    set memory_files [concat $memory_files [pattgen_ctrl_pattgen_rst::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pattgen_rst/sim/"]]
    set memory_files [concat $memory_files [pattgen_ctrl_master::get_memory_files "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_master/sim/"]]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [pattgen_ctrl_pio::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pio/sim/"]]
    set design_files [dict merge $design_files [pattgen_ctrl_tx_clkout::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_tx_clkout/sim/"]]
    set design_files [dict merge $design_files [pattgen_ctrl_mm_clock_crossing_bridge::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_mm_clock_crossing_bridge/sim/"]]
    set design_files [dict merge $design_files [pattgen_ctrl_avmm_rst::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_rst/sim/"]]
    set design_files [dict merge $design_files [pattgen_ctrl_avmm_clk::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_clk/sim/"]]
    set design_files [dict merge $design_files [pattgen_ctrl_pattgen_rst::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pattgen_rst/sim/"]]
    set design_files [dict merge $design_files [pattgen_ctrl_master::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_master/sim/"]]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [list]
    set design_files [concat $design_files [pattgen_ctrl_pio::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pio/sim/"]]
    set design_files [concat $design_files [pattgen_ctrl_tx_clkout::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_tx_clkout/sim/"]]
    set design_files [concat $design_files [pattgen_ctrl_mm_clock_crossing_bridge::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_mm_clock_crossing_bridge/sim/"]]
    set design_files [concat $design_files [pattgen_ctrl_avmm_rst::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_rst/sim/"]]
    set design_files [concat $design_files [pattgen_ctrl_avmm_clk::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_clk/sim/"]]
    set design_files [concat $design_files [pattgen_ctrl_pattgen_rst::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pattgen_rst/sim/"]]
    set design_files [concat $design_files [pattgen_ctrl_master::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_master/sim/"]]
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_master_translator_192/sim/pattgen_ctrl_altera_merlin_master_translator_192_lykd4la.sv"]\"  -work altera_merlin_master_translator_192"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_translator_191/sim/pattgen_ctrl_altera_merlin_slave_translator_191_x56fcki.sv"]\"  -work altera_merlin_slave_translator_191"   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/pattgen_ctrl_altera_mm_interconnect_1920_inv4uay.v"]\"  -work altera_mm_interconnect_1920"                    
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/pattgen_ctrl_altera_mm_interconnect_1920_booixby.v"]\"  -work altera_mm_interconnect_1920"                    
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1922/sim/altera_reset_controller.v"]\"  -work altera_reset_controller_1922"                                           
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1922/sim/altera_reset_synchronizer.v"]\"  -work altera_reset_controller_1922"                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/pattgen_ctrl.v"]\"  -work pattgen_ctrl"                                                                                                          
    return $design_files
  }
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [pattgen_ctrl_pio::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [pattgen_ctrl_tx_clkout::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [pattgen_ctrl_mm_clock_crossing_bridge::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [pattgen_ctrl_avmm_rst::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [pattgen_ctrl_avmm_clk::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [pattgen_ctrl_pattgen_rst::get_elab_options $SIMULATOR_TOOL_BITNESS]
    append ELAB_OPTIONS [pattgen_ctrl_master::get_elab_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [pattgen_ctrl_pio::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [pattgen_ctrl_tx_clkout::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [pattgen_ctrl_mm_clock_crossing_bridge::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [pattgen_ctrl_avmm_rst::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [pattgen_ctrl_avmm_clk::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [pattgen_ctrl_pattgen_rst::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [pattgen_ctrl_master::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_pio::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_tx_clkout::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_mm_clock_crossing_bridge::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_avmm_rst::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_avmm_clk::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_pattgen_rst::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [pattgen_ctrl_master::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [pattgen_ctrl_pio::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pio/sim/"]]
    set libraries [dict merge $libraries [pattgen_ctrl_tx_clkout::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_tx_clkout/sim/"]]
    set libraries [dict merge $libraries [pattgen_ctrl_mm_clock_crossing_bridge::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_mm_clock_crossing_bridge/sim/"]]
    set libraries [dict merge $libraries [pattgen_ctrl_avmm_rst::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_rst/sim/"]]
    set libraries [dict merge $libraries [pattgen_ctrl_avmm_clk::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_avmm_clk/sim/"]]
    set libraries [dict merge $libraries [pattgen_ctrl_pattgen_rst::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_pattgen_rst/sim/"]]
    set libraries [dict merge $libraries [pattgen_ctrl_master::get_dpi_libraries "$QSYS_SIMDIR/../../ip/pattgen_ctrl/pattgen_ctrl_master/sim/"]]
    
    return $libraries
  }
  
}
