// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//--------------------------------------------------------------------------------------------------
//
// Pathological "checkfield" pattern generator. Refer to RP178(NTSC, PAL) and RP198 for details.
//
//--------------------------------------------------------------------------------------------------

module sdi_ii_patho_gen (
  hd_sdn,
  clk,
  rst,
  req,
  ln,
  wn,
  yout,
  cout,

  field1_start_ln,
  field1_pattern_change_ln,
  field2_start_ln,
  field2_pattern_change_ln,
  pal_nstcn
  );

input hd_sdn;
input clk;
input rst;
input req;
input [10:0] ln;
input [12:0] wn;
output [9:0] yout;
output [9:0] cout;
input [10:0] field1_start_ln;
input [10:0] field1_pattern_change_ln;
input [10:0] field2_start_ln;
input [10:0] field2_pattern_change_ln;
input pal_nstcn;

parameter [9:0] Y_BLANKING_DATA = 10'h040;
parameter [9:0] C_BLANKING_DATA = 10'h200;

reg [9:0] cout;
reg [9:0] yout;
reg odd;

always @ (posedge clk or posedge rst)
begin
  if (rst) begin
    yout <= Y_BLANKING_DATA;
    cout <= C_BLANKING_DATA;
    odd  <= 1'b0;
  end
  else if (req) begin
    if (hd_sdn & ln==field1_start_ln & wn==1) begin
      odd <= ~odd;
      if (~odd) begin
        yout <= 10'h198;
      end else begin
        yout <= 10'h190;
      end
      cout <= 10'h300;
    end
    else if (~hd_sdn & ln==field1_start_ln & ((wn==864 & pal_nstcn) | (wn==858 & ~pal_nstcn))) begin
      yout <= 10'h080;
      cout <= 10'h300;
    end
    else if (ln<field1_pattern_change_ln) begin
      yout <= 10'h198;
      cout <= 10'h300;
    end
    else if (ln<field2_start_ln) begin
      yout <= 10'h110;
      cout <= 10'h200;
    end
    else if (ln<field2_pattern_change_ln) begin
      yout <= 10'h198;
      cout <= 10'h300;
    end
    else begin
      yout <= 10'h110;
      cout <= 10'h200;
    end
  end
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "MBeNMpYGPtPl1sE+DQYudSgTsK7EAWNJwUGKRF0u7XRPhowIlls8RJfstyWmsvlOEmdSGdceoRHeaHEQLNzQQIhfBlevOTODcoCezHsI0TKITCVzhv7PoO/WuhggyXiWx6PZ9QL2w6wOssoF+/IIDkKjb9O37NLgtiIz/Y8rj7aO4WI3Z30kcN5p8CvKXADJL6/obbPPFES6e1ypucbAQpHseQQQWhKLHWIfs3d6tL4/T4oIEuWrpTQ5VTkN1pGcggnstLMABWG5R3ael/TCb7SFw4OnwIU2+oYheQVohWQGTIkO6A5FddQXVehS4FMMlN0atbYH8wiQGZotwOqe2NbCEBechU9EgStXkBZ/ldK97niUm6QgNrzZJs4aHKL4L13jzTJFu6/rmAKhXwMyIxCeGBP6klJe8TLyOoTQEyXUDMxtsOkAqLI4bIVGXWmZXVh6YGeMCLHuvl+fqxw5xd0eD9im1RR1+Qgx2JUOxTGfwAebA3RYsKVvecqFOlkt27xsrqymmXinnP4d1MMP46+pCRdeixeGnnGqxQkBQU2Q5sU+9prJjIQowtXI83fFGRfECTo1ie1djdRurtji4noKi9F1smrPWEDqq0I5EWo5NtupBAln06cRARwNKBCowhBynM+4pFx51b2Jr/A2D4dsG8derLo60/VIO/JJInjDptRwgLo/5S+nh6L5L4nwbO4DNAoofr3wpWdyiycFFy8xeeTbtPi1L9cEZB7y20O3QkvoFHfNSInzqrbw7wu80mxg/6eRgChVwXinZT7c//6G1+J7BffwuIqNiS6XtwnjZUPTmABqhYds/RQ3bFhj1NDAjOZ/S7xSCt3U2iDhVMo5dtsy3vdzPiD5iHXr4dwFHknoVDfzDen4EmBkxtEV0CjIJyXGHFksTT3yBf0nNltRblhft7n30AYbC7xbG21W0mCXKrh0JRajqCF731mmDDZQVQOLUBlCqREXUhpgl4URpP6DulDMh/2HQBhN4TM4diXZmRBuUx7LSNYHMRxR"
`endif