# (C) 2001-2023 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


## SDC ##

## The SDC is added as a ENTITY_SDC_FILE, hence paths are relative to the ip_inst_name this is associated with
set ip_inst_name [get_current_instance]


foreach_in_collection node1 [get_nodes $ip_inst_name|x_sip|gen_systempll[0].enabled.ctrl_pll_aibrc_clock_top__pll_slice1_clk_sdc|clk] {
    foreach edge [get_node_info -synch_edges $node1] {
        set clk_name  [get_node_info -name [get_edge_info -src $edge]]
        set freq [expr 450000000 / 1000000.0]
        create_clock -period "$freq MHz" -name $clk_name $clk_name
    }
}




foreach_in_collection node2 [get_nodes $ip_inst_name|x_sip|refclk_fgt_passthru[0].coreclk_enabled.coreclk_sdc|clk] {
    foreach edge1 [get_node_info -synch_edges $node2] {
        set clk_name  [get_node_info -name [get_edge_info -src $edge1]]
        set freq [expr 156250000 / 1000000.0]
        create_clock -period "$freq MHz" -name $clk_name $clk_name
    }
}
set d_cnoc_clk_0_limit1_din_s1 [get_registers -nowarn *|x_sip|d_cnoc_clk_0_limit1]
 if {[get_collection_size $d_cnoc_clk_0_limit1_din_s1 ] > 0} {
     set_false_path -to $d_cnoc_clk_0_limit1_din_s1 
  }
set d_store_cnoc_clk_0_limit1_s1 [get_registers -nowarn *|x_sip|d_store_cnoc_clk_0_limit1]
 if {[get_collection_size $d_store_cnoc_clk_0_limit1_s1 ] > 0} {
     set_false_path -to $d_store_cnoc_clk_0_limit1_s1 
  }
  set cnoc_0_count_limit1_s1 [get_registers -nowarn *|x_sip|cnoc_0_count_limit1]
 if {[get_collection_size $cnoc_0_count_limit1_s1 ] > 0} {
     set_false_path -to $cnoc_0_count_limit1_s1 
  }
 set store_cnoc_clk_0_limit1 [get_registers -nowarn *|x_sip|store_cnoc_clk_0_limit1]
 if {[get_collection_size $store_cnoc_clk_0_limit1] > 0} {
     set_false_path -to $store_cnoc_clk_0_limit1 
  }
set enable_learning_phase_0_ff1_core [get_registers -nowarn *|x_sip|enable_learning_phase_0_ff1_core]
 if {[get_collection_size  $enable_learning_phase_0_ff1_core] > 0} {
     set_false_path -to $enable_learning_phase_0_ff1_core 
  }
 set start_refclk_monitor_0_enable3 [get_registers -nowarn *|x_sip|start_refclk_monitor_0_enable3]
 if {[get_collection_size $start_refclk_monitor_0_enable3] > 0} {
     set_false_path -to $start_refclk_monitor_0_enable3 
  }
 set refclk_fgt_enabled_0_st1 [get_registers -nowarn *|x_sip|refclk_fgt_enabled_0_st1]
 if {[get_collection_size $refclk_fgt_enabled_0_st1] > 0} {
     set_false_path -to $refclk_fgt_enabled_0_st1
  }

 set enable_learning_phase_0_ff1_cnoc [get_registers -nowarn *|x_sip|enable_learning_phase_0_ff1_cnoc]
 if {[get_collection_size $enable_learning_phase_0_ff1_cnoc] > 0} {
     set_false_path -to $enable_learning_phase_0_ff1_cnoc
  }
set d_refclk_0_count_store_en1 [get_registers -nowarn *|x_sip|d_refclk_0_count_store_en1]
 if {[get_collection_size $d_refclk_0_count_store_en1] > 0} {
     set_false_path -to $d_refclk_0_count_store_en1
  }

  

    foreach_in_collection node2 [get_nodes $ip_inst_name|x_sip|cnoc_clk] {
        set clk_name  [get_node_info -name $node2]
        create_clock -period "250 MHz" -name $clk_name $clk_name
    }

