// (C) 2001-2022 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 100 fs / 100 fs
`ifndef str_display
    `define str_display(mystring) if(MODE_MR) $display ("Stream = %0d : %0s",STREAM,mystring) ; else $display ("%0s",mystring)
`endif

module tb_ln_check #(
  parameter     MODE_DL = 0,
  parameter     MODE_MR = 0,
  parameter     STREAM  = 0
)(
  input         checker_rst,
  input         chk_ln,
  input         enable,
  input [2:0]   vid_std,
  input [10:0]  rx_ln,
  input [10:0]  rx_ln_b,
  output reg    bad_ln
);
   integer   expected_ln;
   integer   prev_ln;
   integer   ln_max;

   //register for string display
   reg   [180*8:0]  str;

   always @ (rx_ln or checker_rst)
   begin
      if (checker_rst) begin
         bad_ln = 1'b0;
         expected_ln = 0;
         ln_max = 0;
         prev_ln = 0;
      end
      else if (enable && chk_ln && (rx_ln > 0)) begin

         if (rx_ln == 1 && ln_max == 0) begin
            ln_max = prev_ln;
         end else begin
            if ( vid_std == 3'b010 || MODE_DL ) begin
               if (expected_ln != 0 && (rx_ln != expected_ln || rx_ln_b != expected_ln) ) begin
                  bad_ln = 1'b1;
                  $sformat (str,"Expected ln = %0d, rx_ln = %0d, rx_ln_b = %0d", expected_ln, rx_ln, rx_ln_b);
                  `str_display(str);
               end
            end else begin
               if (rx_ln != expected_ln && expected_ln != 0) begin
                  bad_ln = 1'b1;
                  $sformat (str,"Expected ln = %0d, rx_ln = %0d", expected_ln, rx_ln);
                  `str_display(str);
               end
            end
         end

         if (rx_ln == ln_max) begin
            expected_ln = 1;
         end else begin
            expected_ln = rx_ln + 1;
         end

         prev_ln = rx_ln;
      end
   end

endmodule
