// (C) 2001-2022 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
module tb_top (

);

localparam NUM_STREAMS = 4;
localparam XCVR_RCFG_ADDR_WIDTH = 18;
localparam NUM_DR_HOST = 1;
localparam DR_AVMM_ADDR_WIDTH = 10;
localparam DR_AVMM_DATA_WIDTH = 32;

logic [2:0]                                 tb_test_control_tx_std;
logic [2:0]                                 tb_test_control_pattgen_tx_std;
logic [2:0]                                 sdi_rx_std;
logic                                       tb_test_control_tx_xcvr_refclk;
logic                                       tb_test_control_rx_xcvr_refclk;
logic                                       tb_test_control_rx_coreclk;
logic                                       tb_test_control_tx_chk_refclk;
logic                                       tb_test_control_rx_chk_refclk;
logic                                       tb_test_control_reconfig_clk;
logic                                       tb_test_control_tx_xcvr_refclk_alt;
logic                                       tb_test_control_tx_rst;
logic                                       tb_test_control_tx_rst_sync;
logic                                       tb_test_control_rx_rst;
logic                                       tb_test_control_rx_chk_rst;
logic                                       tb_test_control_reconfig_rst;
logic                                       sdi_tx_p;
logic                                       sdi_rx_p;
logic                                       pll_locked;
logic                                       pll_locked_alt;
logic                                       tx_ready;
logic                                       tx_readyn_sync;
logic                                       sdi_rx_align_locked;
logic [NUM_STREAMS-1:0]                     sdi_rx_trs_locked;
logic [NUM_STREAMS-1:0]                     sdi_rx_trs;
logic [NUM_STREAMS-1:0]                     sdi_rx_ap;
logic [NUM_STREAMS-1:0]                     sdi_rx_eav;
logic [NUM_STREAMS-1:0]                     sdi_rx_h;
logic [NUM_STREAMS-1:0]                     sdi_rx_v;
logic [NUM_STREAMS-1:0]                     sdi_rx_f;
logic [NUM_STREAMS*20-1:0]                  sdi_rx_dataout;
logic [NUM_STREAMS*4-1:0]                   sdi_rx_format;
logic [NUM_STREAMS*11-1:0]                  sdi_rx_ln;
logic [NUM_STREAMS*11-1:0]                  sdi_rx_ln_b;
logic [NUM_STREAMS-1:0]                     sdi_rx_crc_error_c;
logic [NUM_STREAMS-1:0]                     sdi_rx_crc_error_c_b;
logic [NUM_STREAMS-1:0]                     sdi_rx_crc_error_y;
logic [NUM_STREAMS-1:0]                     sdi_rx_crc_error_y_b;
logic [NUM_STREAMS*11-1:0]                  sdi_rx_line_f0;
logic [NUM_STREAMS*11-1:0]                  sdi_rx_line_f1;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte1;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte1_b;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte2;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte2_b;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte3;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte3_b;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte4;
logic [NUM_STREAMS*8-1:0]                   sdi_rx_vpid_byte4_b;
logic [NUM_STREAMS-1:0]                     sdi_rx_vpid_checksum_error;
logic [NUM_STREAMS-1:0]                     sdi_rx_vpid_checksum_error_b;
logic [NUM_STREAMS-1:0]                     sdi_rx_vpid_valid;
logic [NUM_STREAMS-1:0]                     sdi_rx_vpid_valid_b;
logic                                       sdi_rx_frame_locked;
logic                                       sdi_rx_dataout_valid;
logic                                       tb_test_control_pattgen_dl_mapping;
logic [3:0]                                 tb_test_control_pattgen_tx_format;
logic [3:0]                                 tb_test_control_rx_chk_tx_format;
logic                                       tb_test_control_tx_status;
logic                                       sdi_tx_clkout;
logic                                       sdi_rx_clkout;
logic                                       sdi_tx_dataout_valid;
logic                                       tb_test_control_rx_chk_dl_mapping;
logic [NUM_STREAMS*20-1:0]                  pattgen_dout;
logic                                       pattgen_trs;
logic                                       pattgen_dout_valid;
logic [NUM_STREAMS*11-1:0]                  pattgen_ln;
logic [NUM_STREAMS*11-1:0]                  pattgen_ln_b;
logic [NUM_STREAMS*11-1:0]                  pattgen_line_f0;
logic [NUM_STREAMS*11-1:0]                  pattgen_line_f1;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte1;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte1_b;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte2;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte2_b;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte3;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte3_b;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte4;
logic [NUM_STREAMS*8-1:0]                   pattgen_pid_byte4_b;
logic [2:0]                                 tb_test_control_tx_chk_tx_std;
logic [1:0]                                 tb_test_control_tx_chk_start_chk;
logic [1:0]                                 tb_test_control_rx_chk_start_chk;
logic                                       tb_test_control_tx_pll_select;
logic                                       tb_test_control_tx_clkout_match;
logic [1:0]                                 tb_rx_checker_rxcheck_done;
logic                                       tb_rx_checker_chk_completed;
logic                                       tb_rx_checker_rx_check_posedge;
logic                                       gxb_tx_reset_ack;
logic                                       gxb_rx_reset_ack;
logic                                       cdr_reconfig_busy;
logic [NUM_DR_HOST-1:0]                     rcfg_new_cfg_applied_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_new_cfg_applied_ack_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_read_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_write_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_readdata_valid_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_waitrequest_ch;
logic [NUM_DR_HOST*DR_AVMM_ADDR_WIDTH-1:0]  rcfg_avmm_address_ch;
logic [NUM_DR_HOST*DR_AVMM_DATA_WIDTH-1:0]  rcfg_avmm_readdata_ch;
logic [NUM_DR_HOST*DR_AVMM_DATA_WIDTH-1:0]  rcfg_avmm_writedata_ch;
logic                                       tb_test_control_dr_cpu_clk;
logic                                       dr_in_progress;
logic                                       dr_new_cfg_applied;
logic                                       dr_host_avmm_readdata_valid;
logic                                       dr_host_avmm_waitrequest;
logic                                       dr_new_cfg_applied_ack;
logic                                       dr_host_avmm_write;
logic                                       dr_host_avmm_read;
logic [DR_AVMM_ADDR_WIDTH-1:0]              dr_host_avmm_address;
logic [DR_AVMM_DATA_WIDTH-1:0]              dr_host_avmm_readdata;
logic [DR_AVMM_DATA_WIDTH-1:0]              dr_host_avmm_writedata;

sdi_ii_tb_control #(
    .FAMILY                         ("Agilex"),
    .VIDEO_STANDARD                 ("mr"),
    .DIRECTION                      ("tx"),
    .RX_CORECLK_FREQ                ("148.5"),
    .RX_INC_ERR_TOLERANCE           (0),
    .RX_CRC_ERROR_OUTPUT            (0),
    .RX_EN_A2B_CONV                 (0),
    .RX_EN_B2A_CONV                 (0),
    .ED_TXPLL_SWITCH                (0),
    .TXPLL_REFCLK_FREQ              ("148.5"),
    .RXCDR_REFCLK_FREQ              ("148.5"),
    .TEST_LN_OUTPUT                 (0),
    .TEST_SYNC_OUTPUT               (0),
    .TEST_RECONFIG_SEQ              ("half"),
    .TEST_DISTURB_SERIAL            (0),
    .TEST_DL_SYNC                   (0),
    .TEST_TRS_LOCKED                (0),
    .TEST_FRAME_LOCKED              (0),
    .TEST_VPID_OVERWRITE            (1),
    .TEST_MULTI_RECON               (0),
    .TEST_SERIAL_DELAY              (0),
    .TEST_RESET_SEQ                 (0),
    .TEST_RESET_RECON               (0),
    .TEST_RST_PRE_OW                (0),
    .TEST_RXSAMPLE_CHK              (0)
) tb_test_control (
    // Clocks and resets
    .tx_xcvr_refclk                 (tb_test_control_tx_xcvr_refclk),
    .rx_xcvr_refclk                 (tb_test_control_rx_xcvr_refclk),
    .rx_coreclk                     (tb_test_control_rx_coreclk),
    .tx_chk_refclk                  (tb_test_control_tx_chk_refclk),
    .rx_chk_refclk                  (tb_test_control_rx_chk_refclk),
    .reconfig_clk                   (tb_test_control_reconfig_clk),
    .dr_cpu_clk                     (tb_test_control_dr_cpu_clk),
    .tx_rst                         (tb_test_control_tx_rst),
    .rx_rst                         (tb_test_control_rx_rst),
    .rx_chk_rst                     (tb_test_control_rx_chk_rst),
    .reconfig_rst                   (tb_test_control_reconfig_rst),
    .tx_xcvr_refclk_alt             (),
    .tx_coreclk                     (),
    .tx_rst_ch0                     (),
    .rx_rst_ch0                     (),
    .tx_xcvr_refclk_smpte372        (),
    .rx_xcvr_refclk_smpte372        (),
    .tx_coreclk_smpte372            (),
    .rx_coreclk_smpte372            (),
    .tx_rst_smpte372                (),
    .rx_rst_smpte372                (),
    .tx_phy_mgmt_clk_rst            (),
    .rx_phy_mgmt_clk_rst            (),

    // Inputs
    .tx_sdi_serial                  (sdi_tx_p),
    .tx_pll_locked                  (pll_locked),
    .tx_pll_locked_alt              (1'b0),
    .tx_ready                       (tx_ready),
    .tx_clkout_match                (1'b0),
    .rx_check_posedge               (1'b0),
    .rx_chk_done                    (tb_rx_checker_rxcheck_done),
    .rx_chk_completed               (tb_rx_checker_chk_completed),
    .tx_reset_ack                   (gxb_tx_reset_ack),
    .tx_cal_busy                    (1'b0),
    .rx_reset_ack                   (gxb_rx_reset_ack),
    .rx_cal_busy                    (1'b0),
    .pattgen_dout                   (20'd0),
    .pattgen_dvalid                 (1'b0),
    .pattgen_dout_b                 (20'd0),
    .pattgen_dvalid_b               (1'b0),
    .pattgen_trs                    (1'b0),
    .pattgen_trs_b                  (1'b0),
    .tx_sdi_serial_ch1_smpte372     (1'b0),
    .tx_sdi_serial_ch1_smpte372_b   (1'b0),
    .tx_sdi_serial_b                (1'b0),
    .rx_rst_proto                   (1'b0),
    .rx_sdi_start_reconfig          (1'b0),
    .rx_reconfig_busy               (1'b0),
    .rx_chk_done_ch0                (2'b00),
    .rx_chk_completed_ch0           (1'b0),

    // Outputs
    .pattgen_dl_mapping             (tb_test_control_pattgen_dl_mapping),
    .pattgen_tx_std                 (tb_test_control_pattgen_tx_std),
    .pattgen_tx_format              (tb_test_control_pattgen_tx_format),
    .tx_std                         (tb_test_control_tx_std),
    .tx_status                      (tb_test_control_tx_status),
    .rx_sdi_serial                  (sdi_rx_p),
    .tx_chk_tx_std                  (tb_test_control_tx_chk_tx_std),
    .tx_chk_start_chk               (tb_test_control_tx_chk_start_chk),
    .rx_chk_start_chk               (tb_test_control_rx_chk_start_chk),
    .rx_chk_dl_mapping              (tb_test_control_rx_chk_dl_mapping),
    .rx_chk_tx_format               (tb_test_control_rx_chk_tx_format),
    .tx_sdi_start_reconfig          (),
    .tx_sdi_pll_sel                 (),
    .tx_enable_crc                  (),
    .tx_enable_ln                   (),
    .tx_vpid_overwrite              (),
    .pattgen_bar_100_75n            (),
    .pattgen_patho                  (),
    .pattgen_blank                  (),
    .pattgen_no_color               (),
    .pattgen_sgmt_frame             (),
    .pattgen_ntsc_paln              (),
    .tx_dout                        (),
    .tx_dvalid                      (),
    .tx_trs                         (),
    .tx_dout_b                      (),
    .tx_dvalid_b                    (),
    .tx_trs_b                       (),
    .rx_sdi_serial_ch0              (),
    .rx_chk_start_chk_ch0           (),
    .rx_sdi_serial_ch1_smpte372     (),
    .rx_sdi_serial_ch1_smpte372_b   (),
    .rx_sdi_serial_b                ()
);

altera_reset_controller #(
    .NUM_RESET_INPUTS               (1),
    .RESET_REQ_WAIT_TIME            (1),
    .MIN_RST_ASSERTION_TIME         (3),
    .RESET_REQ_EARLY_DSRT_TIME      (1)
) test_control_tx_rst_sync_inst (
// Input Clock and reset
    .reset_in0                      (tb_test_control_tx_rst),
    .clk                            (sdi_tx_clkout),
// Outputs
    .reset_out                      (tb_test_control_tx_rst_sync)
);

altera_reset_controller #(
    .NUM_RESET_INPUTS               (1),
    .RESET_REQ_WAIT_TIME            (1),
    .MIN_RST_ASSERTION_TIME         (3),
    .RESET_REQ_EARLY_DSRT_TIME      (1)
) tx_readyn_sync_inst (
// Input Clock and reset
    .reset_in0                      (~tx_ready),
    .clk                            (sdi_tx_clkout),
// Outputs
    .reset_out                      (tx_readyn_sync)
);

sdi_ii_ed_vid_pattgen #(
    .OUTW_MULTP                     (NUM_STREAMS),
    .SD_BIT_WIDTH                   (10),
    .TEST_GEN_ANC                   (0),
    .TEST_GEN_VPID                  (0),
    .TEST_VPID_PKT_COUNT            (1),
    .TEST_ERR_VPID                  (0),
    .TEST_VPID_OVERWRITE            (1)
) pattgen (
    // Clocks and resets
    .clk                            (sdi_tx_clkout),
    .rst                            (tb_test_control_tx_rst_sync | tx_readyn_sync),

    // Inputs
    .enable                         (sdi_tx_dataout_valid),
    .tx_std                         (tb_test_control_pattgen_tx_std),
    .tx_format                      (tb_test_control_pattgen_tx_format),
    .dl_mapping                     (tb_test_control_pattgen_dl_mapping),
    .bar_100_75n                    (1'b1),
    .patho                          (1'b0),
    .blank                          (1'b0),
    .no_color                       (1'b0),
    .sgmt_frame                     (1'b0),
    .ntsc_paln                      (1'b0),

    // Outputs
    .dout_valid                     (pattgen_dout_valid),
    .trs                            (pattgen_trs),
    .dout                           (pattgen_dout),
    .ln                             (pattgen_ln),
    .ln_b                           (pattgen_ln_b),
    .line_f0                        (pattgen_line_f0),
    .line_f1                        (pattgen_line_f1),
    .vpid_byte1                     (pattgen_pid_byte1),
    .vpid_byte2                     (pattgen_pid_byte2),
    .vpid_byte3                     (pattgen_pid_byte3),
    .vpid_byte4                     (pattgen_pid_byte4),
    .vpid_byte1_b                   (pattgen_pid_byte1_b),
    .vpid_byte2_b                   (pattgen_pid_byte2_b),
    .vpid_byte3_b                   (pattgen_pid_byte3_b),
    .vpid_byte4_b                   (pattgen_pid_byte4_b),
    .dout_b                         (),
    .dout_valid_b                   (),
    .trs_b                          ()
);

xcvr_ref_sysclk xcvr_ref_sysclk_inst (
// Input
    .in_refclk_fgt_0                (tb_test_control_reconfig_clk),
    .in_refclk_fgt_1                (tb_test_control_rx_xcvr_refclk),

// Output
    .out_systempll_clk_0            (),
    .out_systempll_synthlock_0      (),
    .out_refclk_fgt_1               ()
);

tx_mr_top #(
    .NUM_STREAMS                                (NUM_STREAMS)
) tx_inst (
// Clocks and reset
    .tx_resetn                                  (~tb_test_control_tx_rst),
    .sdi_tx_pclk                                (sdi_tx_clkout),
    .tx_pll_refclk                              (),
    .system_pll_clk                             (),

// Inputs
    .sdi_tx_enable_crc                          (1'b0),
    .sdi_tx_enable_ln                           (1'b1),
    .sdi_tx_ln                                  (pattgen_ln),
    .sdi_tx_ln_b                                (pattgen_ln_b),
    .tx_vid_data                                (pattgen_dout),
    .tx_vid_datavalid                           (pattgen_dout_valid),
    .tx_vid_std                                 (tb_test_control_tx_std),
    .tx_vid_trs                                 (pattgen_trs),

// Outputs
    .tx_vid_clkout                              (sdi_tx_clkout),
    .tx_pll_locked                              (pll_locked),
    .gxb_tx_serial_data                         (sdi_tx_p),
    .gxb_tx_serial_data_n                       (),
    .gxb_tx_ready                               (tx_ready),
    .gxb_tx_reset_ack                           (gxb_tx_reset_ack),
    .sdi_tx_datavalid                           (sdi_tx_dataout_valid)
);

rx_mr_top #(
    .MRPHY_RX_BASE_PROFILE          (15'd1),
    .NUM_STREAMS                    (NUM_STREAMS)
) rx_inst (
// Clock and reset
    .rx_resetn                      (~tb_test_control_rx_rst),
    .rx_core_refclk                 (tb_test_control_rx_coreclk),
    .rx_cdr_refclk                  (),
    .system_pll_clk                 (),
    .rx_rcfg_mgmt_resetn            (~tb_test_control_reconfig_rst),
    .rx_rcfg_mgmt_clk               (tb_test_control_rx_coreclk),

// Inputs
    .gxb_rx_serial_data             (sdi_rx_p),
    .gxb_rx_serial_data_n           (~sdi_rx_p),
    .dr_rx_new_cfg_applied          (rcfg_new_cfg_applied_ch[0]),
    .dr_rx_avmm_readdata_valid      (rcfg_avmm_readdata_valid_ch[0]),
    .dr_rx_avmm_waitrequest         (rcfg_avmm_waitrequest_ch[0]),
    .dr_rx_avmm_readdata            (rcfg_avmm_readdata_ch[0*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),

// Outputs
    .rx_vid_clkout                  (sdi_rx_clkout),
    .rx_vid_data                    (sdi_rx_dataout),
    .rx_vid_datavalid               (sdi_rx_dataout_valid),
    .rx_vid_std                     (sdi_rx_std),
    .rx_vid_locked                  (sdi_rx_frame_locked),
    .rx_vid_hsync                   (sdi_rx_h),
    .rx_vid_vsync                   (sdi_rx_v),
    .rx_vid_f                       (sdi_rx_f),
    .rx_vid_trs                     (sdi_rx_trs),
    .sdi_rx_rst_proto_out           (),
    .sdi_rx_align_locked            (sdi_rx_align_locked),
    .sdi_rx_trs_locked              (sdi_rx_trs_locked),
    .sdi_rx_clkout_is_ntsc_paln     (),
    .sdi_rx_format                  (sdi_rx_format),
    .sdi_rx_ap                      (sdi_rx_ap),
    .sdi_rx_eav                     (sdi_rx_eav),
    .sdi_rx_ln                      (sdi_rx_ln),
    .sdi_rx_ln_b                    (sdi_rx_ln_b),
    .sdi_rx_line_f0                 (sdi_rx_line_f0),
    .sdi_rx_line_f1                 (sdi_rx_line_f1),
    .sdi_rx_vpid_byte1              (sdi_rx_vpid_byte1),
    .sdi_rx_vpid_byte2              (sdi_rx_vpid_byte2),
    .sdi_rx_vpid_byte3              (sdi_rx_vpid_byte3),
    .sdi_rx_vpid_byte4              (sdi_rx_vpid_byte4),
    .sdi_rx_vpid_checksum_error     (sdi_rx_vpid_checksum_error),
    .sdi_rx_vpid_valid              (sdi_rx_vpid_valid),
    .sdi_rx_vpid_byte1_b            (sdi_rx_vpid_byte1_b),
    .sdi_rx_vpid_byte2_b            (sdi_rx_vpid_byte2_b),
    .sdi_rx_vpid_byte3_b            (sdi_rx_vpid_byte3_b),
    .sdi_rx_vpid_byte4_b            (sdi_rx_vpid_byte4_b),
    .sdi_rx_vpid_checksum_error_b   (sdi_rx_vpid_checksum_error_b),
    .sdi_rx_vpid_valid_b            (sdi_rx_vpid_valid_b),
    .cdr_reconfig_busy              (cdr_reconfig_busy),
    .dr_rx_new_cfg_applied_ack      (rcfg_new_cfg_applied_ack_ch[0]),
    .dr_rx_avmm_write               (rcfg_avmm_write_ch[0]),
    .dr_rx_avmm_read                (rcfg_avmm_read_ch[0]),
    .dr_rx_avmm_writedata           (rcfg_avmm_writedata_ch[0*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),
    .dr_rx_avmm_address             (rcfg_avmm_address_ch[0*DR_AVMM_ADDR_WIDTH+:DR_AVMM_ADDR_WIDTH]),
    .gxb_rx_reset_ack               (gxb_rx_reset_ack),
    .gxb_rx_ready                   ()
);

dr_f dr_inst  (
    .i_csr_clk                      (tb_test_control_rx_coreclk),
    .i_cpu_clk                      (tb_test_control_dr_cpu_clk),
    .i_rst_n                        (~tb_test_control_reconfig_rst),
        
    //User Interface status
    .o_dr_curr_profile_id           (),
    .o_dr_new_cfg_applied           (dr_new_cfg_applied),
    .o_dr_in_progress               (dr_in_progress),
    .i_dr_new_cfg_applied_ack       (dr_new_cfg_applied_ack),

    // Master 1 (Host software interface)
    .i_dr_host_avmm_writedata       (dr_host_avmm_writedata),
    .i_dr_host_avmm_read            (dr_host_avmm_read),
    .i_dr_host_avmm_address         (dr_host_avmm_address),
    .i_dr_host_avmm_write           (dr_host_avmm_write),
    .o_dr_host_avmm_readdata        (dr_host_avmm_readdata),
    .o_dr_host_avmm_waitrequest     (dr_host_avmm_waitrequest),
    .o_dr_host_avmm_readdata_valid  (dr_host_avmm_readdata_valid)
);

// -------------------------------------------------------------------------
// DR Arbiter
// -------------------------------------------------------------------------
vid_conn_dr_arbiter #(
    .NUM_DR_HOST                        (NUM_DR_HOST),
    .PIPELINE_ENA                       (0),
    .AVMM_ADDRESS_WIDTH                 (DR_AVMM_ADDR_WIDTH), 
    .AVMM_DATA_WIDTH                    (DR_AVMM_DATA_WIDTH)
) dr_arb_inst (
    .clk                                (tb_test_control_rx_coreclk),
    .reset                              (tb_test_control_reconfig_rst),
    .reconfig_en                        (cdr_reconfig_busy),

    .rcfg_mgmt_write_ch                 (rcfg_avmm_write_ch),
    .rcfg_mgmt_read_ch                  (rcfg_avmm_read_ch),
    .rcfg_mgmt_address_ch               (rcfg_avmm_address_ch),
    .rcfg_mgmt_writedata_ch             (rcfg_avmm_writedata_ch),
    .rcfg_mgmt_readdata_ch              (rcfg_avmm_readdata_ch),
    .rcfg_mgmt_waitrequest_ch           (rcfg_avmm_waitrequest_ch),
    .rcfg_mgmt_readdata_valid_ch        (rcfg_avmm_readdata_valid_ch),
    .rcfg_mgmt_new_cfg_applied_ch       (rcfg_new_cfg_applied_ch),
    .rcfg_mgmt_new_cfg_applied_ack_ch   (rcfg_new_cfg_applied_ack_ch),

    .dr_avmm_write                      (dr_host_avmm_write),
    .dr_avmm_read                       (dr_host_avmm_read),
    .dr_avmm_address                    (dr_host_avmm_address),
    .dr_avmm_writedata                  (dr_host_avmm_writedata),
    .dr_avmm_readdata                   (dr_host_avmm_readdata),
    .dr_avmm_waitrequest                (dr_host_avmm_waitrequest),
    .dr_avmm_readdata_valid             (dr_host_avmm_readdata_valid),
    .dr_new_cfg_applied                 (dr_new_cfg_applied),
    .dr_new_cfg_applied_ack             (dr_new_cfg_applied_ack)
);

sdi_ii_tb_tx_checker #(
    .FAMILY                         ("Agilex"),
    .VIDEO_STANDARD                 ("mr"),
    .RX_INC_ERR_TOLERANCE           (0),
    .RX_EN_A2B_CONV                 (0),
    .RX_EN_B2A_CONV                 (0)
) tb_tx_checker (
    // Clocks and resets
    .ref_clk                        (tb_test_control_tx_chk_refclk),
    
    // Inputs
    .sdi_serial                     (sdi_tx_p),
    .sdi_serial_b                   (1'b0),
    .tx_status                      (tb_test_control_tx_status),
    .chk_tx                         (tb_test_control_tx_chk_start_chk),
    .tx_std                         (tb_test_control_tx_chk_tx_std),
    .tx_clkout                      (1'b0),

    // Outputs
    .tx_clkout_match                ()
);

sdi_ii_tb_rx_checker #(
    .FAMILY                         ("Agilex"),
    .VIDEO_STANDARD                 ("mr"),
    .SD_BIT_WIDTH                   (10),
    .DIRECTION                      ("tx"),
    .RX_INC_ERR_TOLERANCE           (0),
    .RX_CRC_ERROR_OUTPUT            (0),
    .RX_EN_VPID_EXTRACT             (0),
    .RX_EN_A2B_CONV                 (0),
    .RX_EN_B2A_CONV                 (0),
    .TX_EN_VPID_INSERT              (0),
    .ED_TXPLL_SWITCH                (0),
    .TEST_LN_OUTPUT                 (0),
    .TEST_SYNC_OUTPUT               (0),
    .TEST_DISTURB_SERIAL            (0),
    .TEST_DATA_COMPARE              (0),
    .TEST_DL_SYNC                   (0),
    .TEST_TRS_LOCKED                (0),
    .TEST_FRAME_LOCKED              (0),
    .TEST_VPID_OVERWRITE            (1),
    .TEST_RESET_RECON               (0),
    .TEST_RST_PRE_OW                (0),
    .TEST_RXSAMPLE_CHK              (0),
    .TEST_GEN_ANC                   (0),
    .TEST_GEN_VPID                  (0),
    .TEST_VPID_PKT_COUNT            (1),
    .TEST_ERR_VPID                  (0),
    .CH_NUMBER                      (1)
) tb_rx_checker (
    // Clocks and resets
    .rx_clk                         (sdi_rx_clkout),
    .rx_refclk                      (tb_test_control_rx_chk_refclk),
    .ref_rst                        (tb_test_control_rx_chk_rst),
    .tx_clk                         (1'b0),
    .rx_core_rst                    (tb_test_control_rx_rst),

    // Inputs
    .align_locked                   (sdi_rx_align_locked),
    .trs_locked                     (sdi_rx_trs_locked),
    .frame_locked                   (sdi_rx_frame_locked),
    .rxdata_valid                   (sdi_rx_dataout_valid),
    .dl_mapping                     (tb_test_control_rx_chk_dl_mapping),
    .chk_rx                         (tb_test_control_rx_chk_start_chk),
    .tx_format                      (tb_test_control_rx_chk_tx_format),
    .tx_std                         (tb_test_control_tx_std),
    .rx_sdi_start_reconfig          (rcfg_new_cfg_applied_ack_ch[0]),
    .tx_sdi_reconfig_done           (1'b0),
    .rx_f                           (sdi_rx_f),
    .rx_v                           (sdi_rx_v),
    .rx_h                           (sdi_rx_h),
    .rx_ap                          (sdi_rx_ap),
    .rxdata                         (sdi_rx_dataout),
    .rx_ln                          (sdi_rx_ln),
    .rx_ln_b                        (sdi_rx_ln_b),
    .rx_std                         (sdi_rx_std),
    .rx_vpid_byte1                  (sdi_rx_vpid_byte1),
    .rx_vpid_byte2                  (sdi_rx_vpid_byte2),
    .rx_vpid_byte3                  (sdi_rx_vpid_byte3),
    .rx_vpid_byte4                  (sdi_rx_vpid_byte4),
    .rx_vpid_valid                  (sdi_rx_vpid_valid),
    .rx_vpid_checksum_error         (sdi_rx_vpid_checksum_error),
    .rx_line_f0                     (sdi_rx_line_f0),
    .rx_line_f1                     (sdi_rx_line_f1),
    .rx_vpid_byte1_b                (sdi_rx_vpid_byte1_b),
    .rx_vpid_byte2_b                (sdi_rx_vpid_byte2_b),
    .rx_vpid_byte3_b                (sdi_rx_vpid_byte3_b),
    .rx_vpid_byte4_b                (sdi_rx_vpid_byte4_b),
    .rx_vpid_valid_b                (sdi_rx_vpid_valid_b),
    .rx_vpid_checksum_error_b       (sdi_rx_vpid_checksum_error_b),
    .align_locked_b                 (1'b0),
    .trs_locked_b                   (1'b0),
    .dl_locked                      (1'b0),
    .frame_locked_b                 (1'b0),
    .rxdata_b                       (20'd0),
    .rxdata_valid_b                 (1'b0),
    .rx_format                      (sdi_rx_format),
    .txdata                         ({20*NUM_STREAMS{1'b0}}),
    .txdata_valid                   (1'b0),
    .txdata_b                       (20'd0),
    .txdata_valid_b                 (1'b0),
    .rx_trs                         ({NUM_STREAMS{1'b0}}),
    .rx_eav                         ({NUM_STREAMS{1'b0}}),
    .rx_crc_error_c                 ({NUM_STREAMS{1'b0}}),
    .rx_crc_error_y                 ({NUM_STREAMS{1'b0}}),
    .rx_crc_error_c_b               ({NUM_STREAMS{1'b0}}),
    .rx_crc_error_y_b               ({NUM_STREAMS{1'b0}}),

    // Outputs
    .rxcheck_done                   (tb_rx_checker_rxcheck_done),
    .chk_completed                  (tb_rx_checker_chk_completed),
    .rx_check_posedge               ()
);

sdi_ii_agi_demo_auto_tiles  sdi_ii_agi_demo__tiles_inst (
);

endmodule

